\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 17))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Heilig"
  subtitle = "(2)"
  composer = \markup \center-column { "nach Hilarion Alfejew" \small 
  "Metropolit von Wolokolamsk, 2007" }
  meter = "Andante"
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Hei -- lig, hei -- lig, hei -- lig ist der Herr,
  der __ Herr Ze -- ba -- oth,
  er -- füllt sind Him -- mel und auch Er -- de 
  von Dei -- ner Herr -- lich -- keit.
  Ho -- san -- na in der Hö -- he.
  Ge -- prie -- sen, der da kommt, der da __ kommt
  im Na -- men des Herrn. __
  Ho -- san -- na in der Hö -- he.
}
menWords = \lyricmode {
  Hei -- lig, hei -- lig, hei -- lig ist der Herr,
  der __ Herr Ze -- ba -- oth,
  er -- füllt sind Him -- mel und auch Er -- de 
  von Dei -- ner Herr -- lich -- keit.
  Ho -- san -- na in der Hö -- he.
  Ge -- prie -- sen, der da __ kommt, der da __ kommt
  im Na -- men des Herrn. __
  Ho -- san -- na in der Hö -- he.
}

sopMusic = \relative c' {
  f4 f f8( g8) a4 g4.  a8 g4 f8( e) f2 f4( g) a2
  g8( a) b4 a4. a8 a8( g) a( b) c4. ( d8 c b a4) b4 
  b8 c b8( a g4) a a g4 a g( f) e2 f
  f8( g) a4 g4 g8 a g4( f8 e) f2
  f4( g) a a g8( a) b4 a2 a8( g) a( b) c4. d8  
  c8( b a4) b4 b8( c) b( a g4 a2)
  g4 a g4 f8 f 
  <<
   { \voiceOne g4( a b2) a }
   \new Voice { \voiceOne e2 e f^\fermata }
  >>
  \oneVoice
  \bar "|."
}

altoMusic = \relative c' {
  f4 f f f f f e4 c c2 c4( e) f2 f4 f f4. f8
  f4 f g2( fis2) f4 f8 f e2 f4 f d4 d d2 c c2
  f4 f f f8 f e4( c) c2 
  c4( e) f f f f f2 f4 f g g fis2 f4 f
  e2( f2) d4 d d d8 d c2( c) c
}

tenorMusic = \relative c' {
  a4 a a8( b) c4 b b b b a2 a4( b) c2
  b8( c) d4 c4. c8 c8( b) c( d) c2( d) d4 d8 d
  c2 c4 c b c b( a) g8( a b4) a2
  a8( b) c4 b4 b8 b b2 a
  a4( b) c c b8( c) d4 c2 c8( b) c( d) c4 c d2
  d4 d c2( c) b4 c b a8 a a8( b c4 d2) c2
}

bassMusic = \relative c {
  f4 f f f d  d c c f2 f f d8([ c]) b([ d]) f4. f8
  f4 f es2( d) g4 g8 g c,2 f4 f b,4 b b2 c f2
  f4 f d d8 d c2 f2
  f2 f4 f d8([ c]) b([ d]) f2 f4 f es es
  d2 g4 g c,2( f2) 
  b,4 b b b8 b c2( c) f
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \addlyrics { \menWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altoMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}