\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 18))
  %system-system-spacing = #'((basic-distance . 15))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  %ragged-right = ##t
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Gebet"
  subtitle = " "
  %subsubtitle = "Op. 40"
  %subsubtitle = "Op. 21"
  %poet = "după Andra Gogan"
  composer = \markup \center-column { "nach Constantin Drăgușin" \small 
  "(1931 – 2014)" }
  %arranger = "Satz J. Knuth"
  %meter = "Andante sostenuto"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOn
  %\cadenzaOn
  \time 4/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Herr, Du, mein Gott, Dich be -- ten wir an,
  er -- he -- ben un -- ser Ge -- bet zu __ Dir
  Hym -- nen und Psal -- men sin -- gen wir Dir
  und prei -- sen Dich.
 
  Hal -- le -- lu -- ja,
  hal -- le -- lu -- ja, hal -- le -- lu -- ja, __
  hal -- le -- lu -- ja.
}
  
bassWords = \lyricmode {
  %\set stanza = "1. "
  Herr, Du, mein Gott, Dich be -- ten wir an,
  er -- he -- ben un -- ser Ge -- bet zu __ Dir
  Hym -- nen und Psal -- men sin -- gen wir Dir
  und prei -- sen Dich.
  
  Hal -- le -- lu -- ja, hal -- le -- lu -- ja, 
  hal -- le -- lu -- ja, hal -- le -- lu -- ja, __ 
  hal -- le -- lu -- ja.
}

sopMusic = \relative c'' {
  a2^\p g4 a f2.^\< g4 a4.\!( b8 a4 g8[ a])
  f2 a g2. b8\rest
  f8 f4^\p^\< f g4 a8 a b2\! f4( g) a1^\< c2\! g4 b
  a4.^\> g8 f4 e8\! f g4. g8 f4 e f2. b4\rest
  a2^\p( g4) a4 f2(^\< g) a2.\! b4\rest c2( b4) a b2(^\> g) f\!
  c4 c a'4.( g8 f4 e) f1( f f2) 
  f4^\pp f f2( f) f2. b4\rest  
  \bar"|."
}

altMusic = \relative c' {
  f2 f4 f f2. e4 f1 f2 f e2. b'8\rest
  d,8 d4 d e4 f8 f f2 f4( f) f1 %e2 e4 e
  g2 g4 g
  f4. e8 f4 e8 f e4. e8 c4 c f2. b4\rest
  f2. f4 d2( e) f2. b4\rest e,( f g) f e2( e) f 
  c4 c f4.( e8 c4 c) \once \hide f1( \once \hide f \once \hide f2) 
  c4 c d2( des) c2. b'4\rest  
}

tenorMusic = \relative c' {
  c2 b4 c b2. c4 c4.( d8 c4 b8[ c]) a2 c c2. d,8\rest
  a'8 a4 a c4 c8 c d2 d4( des) c1
  c2 c4 c c4. c8 c4 c8c c4. b8 a4 b a2. d,4\rest
  c'2( b4) c a2( c )c2. d,4\rest c'2. c4 c2( c4 b) a2
  c4 c c2.( b4) a2 a4 a b2 a4( c b a)
  a a b1 a2. d,4\rest  
}

bassMusic = \relative c {
  f2 f4 f d2. c4 f1 c2 f c2. d8\rest
  d8 d4 d c4 f8 f <b b,>2 <b b,> 
  f1 c2 c4 c 
  f4. g8 a4 b8 a g4 c, c c f2. d4\rest r1
  d4 d c2 f2. d4\rest r1
  c4 c c2 f c'4 c f,4.( g8 a4 b8[ g]) f2
  c4 c d2 c4( es d c)
  f4 f <f b,>1 <f f,>2. d4\rest  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \global \voiceOne \sopMusic }
     \new Voice { \global \voiceTwo \altMusic }
     \addlyrics { \sopWords }
    >>
      
    \new Staff <<
     \clef bass
     \new Voice { \voiceOne \global \tenorMusic }
     \new Voice { \voiceTwo \global \bassMusic }
     %\new Voice { \global \bassMusic }
     \addlyrics { \bassWords }
     %\new Lyrics \lyricsto "split" { a -- şa, a -- şa şi pre pă -- mânt. }
     
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 70
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

