\version "2.24.0"
\language "deutsch"

\paper {
  %#(set-paper-size "a4")
  %between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 19))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Dich loben wir"
  subtitle = "(2)"
  composer =  \markup \center-column { "nach Gavriil Musicescu" \small 
  "(1847–1903)" }
  meter = "Andante"
  tagline=""
}

global = {
  \key f \major
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Dich lo -- ben, Dich lo -- ben wir
  Dich prei -- sen, prei -- sen wir, o, Herr;
  Dir __ dan -- ken wir, Dir __ dan -- ken wir, 
  Dir __ dan -- ken wir, o Herr.
  Und be -- ten, be -- ten zu Dir, zu __ Dir,
  un -- ser Gott, un -- ser Gott, __ zu __ Dir,
  be -- ten zu Dir, un -- ser Gott.
}

altWords = \lyricmode {
  
}

bassWords = \lyricmode {
  Dich lo -- ben, Dich lo -- ben wir
  Dich prei -- sen, prei -- sen wir, __ o, Herr;
  Dir __ dan -- ken wir, Dir dan -- ken wir, 
  dan -- ken wir, o Herr.
  Und be -- ten, be -- ten zu Dir, 
  un -- ser Gott, un -- ser Gott, __ zu Dir,
  be -- ten zu Dir, un -- ser Gott.
}

sopMusic = \relative c'' {
   a^\pp
   %\override Hairpin.minimum-length = #5
   c2.^\accent a4 c2 b4 a g2. \breathe
   g4 a2 a b( a4) g b2. a4 b2. b4\rest
   b4.( g8) a4 b c1
   b4.( g8) a4 b a1
   b4.( b8) a4 g a2 g f2. b4\rest
   f2 g a a8 b c4 b2 \breathe
   d8.^\markup "rubato"([ c16 b8 a]) b2 g4 g
   a2 c4 d c( a) c8.([ b16 a8 g]) a2 
   b4 b a4 f g8(a) g4^\fermata f2.   
   \bar "|."
}

altMusic = \relative c' {
    f4
    a2. f4 g2 g4 f e2.
    e4 f2 f f( fis4) g g2. fis4 g2. b4\rest
    g4.( e8) f4 g a1
    g4.( e8) f4 g f1
    g4.( g8) f4 e f2 e d2. b'4\rest
    d,2 e f fis8 g a4 g2
    b8.([ a16 g8 fis]) g2 e4 e
    f2 a4 g a( f) a8.([ g16 f8 e]) f2
    f4 f f4 f e e f2.
}

tenorMusic = \relative c {
    d4\rest
    d4\rest c' c c c2 c4 c c2. d,4\rest
    d4\rest c' d d d2( d4) d c2( a4) d d2. d,4\rest
    d1\rest c'2 c4 c c1
    c2 c4 d e2
    d4 d d2 cis d2. d,4\rest
    a'2 c c d8 d d4 d2
    d,2\rest d2\rest c'4 c c2 f4 f f4( c) c2 c 
    d4 d c4 a b a a2.    
}

bassMusic = \relative c {
  d4\rest
  d4\rest f f f e2 e4 f c2. d4\rest
  d4\rest f d c b2( d4) g es4( d8[ c] d4) d g2. d4\rest
  d1\rest f4.( e8) f4 a, c1
  f2 e4 d cis2
  d4 d d2 a' d,2. d4\rest
  d2 c f d8 d d4 g2
  d2\rest d2\rest c4 c f2 f4 b, c2 c f
  b,4 b c c c c f2.  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     %\set Staff.instrumentName = #"S" 
     \new Voice { \voiceOne \global \sopMusic }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \sopWords }
    >>

   \new Staff <<
      %\set Staff.instrumentName = #"B"
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 55
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}