\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 30))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #3
}

\header {
  title = "Den Vater"
  subtitle = "Friedenskuss"
  composer = "nach N. Lungu" 
  %meter = " "
  tagline=""
}

global = {
  \key f \major
  %\time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}

womenWords = \lyricmode {
  Und mit dei -- nem Geist.
  Den Va -- ter, den Sohn und den Hei -- li -- gen Geist, __
  Drei -- fal -- tig -- keit
  ei -- nes __ We -- sens und un -- ge -- teilt. __
}

menWords = \lyricmode {
  Und mit dei -- nem Geist.	
  Den Va -- ter, den Sohn und den Hei -- li -- gen Geist, __
  Drei -- fal -- tig -- keit
  ei -- nes We -- sens und un -- ge -- teilt. __
}

sopMusic = \relative c' {
  %\mark "                  Şi duhului tău"
  %\override Lyrics.LyricSpace.minimum-distance = #2.0
  %\override Lyrics.LyricHyphen.minimum-distance = #1.0
  \partial 2 a'4^\mf^\< a
  b8\!([ a]) g4^\> a2\! \bar "||"   
  %\mark "            Pe Tatăl"
  \partial 4 c,4^\mf
  f2 f4 f4 g2 f4 e4 f4 g8 g a2( a8) h8\rest
  \partial 4 a4 f'4. f8 e2 
  d4( c4) b8([ a8] g4) c8([ b a8 b8)] a2
  f2 g4 g4 a4( g4 f4 e4 d2)
  \bar "|."
}

altMusic = \relative c' {
  f4 f g8([ f]) e4 f2
  c4 f2 f4 f4 e2 f4 e4 d e8 e f2( f8) h8\rest
  a4 a4. c8 c2 b4( a) g8([ f] e4) a8([ g f g]) f2
  f2 e4 e f( e d cis d2)
}

tenorMusic = \relative c {
  f4 f g g a2
  c,4 f2 f4 f g2 f4 g a b8 b c2( c8)
  d,8\rest d4\rest d2\rest d4\rest
  a'4 b8 b c4 c d e( d) c2
  %a'4 b8 b a4 g8([ a]) b( c) c4( d) c2
  d,2 e4 e f2( f4 e d2)
}

bassMusic = \relative c {
  f4 f c c f2	
  c4 f2 f4 f c2 d4 a d c8 c f2( f8)
  d8\rest d4\rest d2\rest d4\rest
  a'4 b8 b a4 g8([ a]) b( c) a([ g f c]) f2
  d2 c4 c f( e d \tuplet 3/2 { a8[ b cis] } d2)
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}


 \score {
  \myScore
  \layout { }
  \midi { \midiOutput }
 }

 \score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
 }
 
 \score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
 }

\score {
  %\unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
 }

 \score {
  %\unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
 }
 
