\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Im Namen des Herrn"
  subtitle = "8. Ton"
  %subsubtitle = "Op. 21"
  %poet = "Vasile Militaru (1885 - 1959)"
  composer =  "nach N. Lungu"
  %arranger = "io"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOff
  %\cadenzaOn
  %\time 2/4
  \partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Dir, o, Herr. A -- men.
  Im Na -- men des Herrn.
  Herr, er -- bar -- me Dich.
}

menWords = \womenWords

sopMusic = \relative c'' {
  a4^\markup{\hspace #-4.0 \bold \box 1}^\mp 
  g8(^\< f)\! g4 a^\> f4. h8\rest\! \bar "||"
  \partial 2
  a4^\markup{\hspace #-2.0 \bold \box 2} 
  g8(^\< a)\! b4 c^\> a4. h8\rest\! \bar "||"
  a4^\accent g^\> f4 h4\rest\!
  c2 c \bar"||"
  \partial 4 a4 c2 g8([ a] b4) a( g) f2 \bar"||"
  \partial 2
  a4^\mp g8(^\< f) g4\! a^\> f4. h8\rest\!  
  \bar "|." %\break
  
  %a4 c2 g8([ a]) b4 a g f2
 %\bar "|."
  
}

altMusic = \relative c' {
  f4 e8( f) e4 e f4. h8\rest
  f4 e8( f) g4 a f4. h8\rest
  f4 e f h4\rest
  a2 a
  a4 a2 e8([ f] g4) f( e) f2
  f4 e8( f) e4 e f4. h8\rest
}

tenorMusic =  \relative c {
  f4 g8( a) g4 a a4. d,8\rest
  a'4 b8( c) c4 c c4. d,8\rest
  f4 g a d,4\rest
  a'2 c
  c4 c2 d c4( b) a2
  a4 b8( c) c4 c c4. d,8\rest
}

bassMusic = \relative c {
  f4 e8( f) c4 c f4. d8\rest
  f4 e8( f) b,4 c f4. d8\rest
  f4 c <f f,> d4\rest
  f2 f
  f4 f2 c c <f f,>
  f4 e8( f) c4 c f4. d8\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}