\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 23))
  %markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 1\mm
  bottom-margin = 0\mm
  %ragged-right = ##f
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Christus ist auferstanden"
  subtitle = "Ostertroparion"
  %1-4.4.20
  subsubtitle = "(3 Varianten)"
  composer = "nach Al. Podoleanu (1846 - 1907)"
  arranger = \markup \center-column { "G. Musicescu (1847 - 1903)" \small
       "gr.-russ. Choral, 5. Ton" }
  %meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOff
  %\cadenzaOn
  \time 3/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Chris -- tus ist auf -- er -- stan -- den von den To -- ten,
  im To -- de be -- zwang Er den Tod,
  hat al -- len in den Grä -- bern das Le -- ben ge -- schenkt. 
  
  Chris -- tus ist auf -- er -- stan -- den von den To -- ten,
  im To -- de be -- zwang Er den Tod,
  hat al -- len in den Grä -- bern 
  das Le -- ben, das Le -- ben ge -- schenkt. 
  
  
  Christ ist er -- stan -- den von den To -- ten,
  im To -- de be -- zwang Er den Tod,
  hat al -- len in den Grä -- bern
  das Le -- ben ge -- schenkt.
}

menWords = \womenWords


sopMusic = \relative c'' {
  c4 ^\markup{\hspace #-2.0 \bold \box 1}
  c b a4( b) c c c4 b8 b a4 a \breathe 
  a4 a g a b a a g2 \breathe
  c4 c a b8 c d4 c d c b b a2 b4\rest \bar"||"
  
  a4 ^\markup{\hspace #-2.0 \bold \box 2}
  a g4 f( a) c c8 b a4 g f f
  a4 c c b a b c d2
  c4 b b c8 b a4 a b8([ a]) g4 g
  a8([ b]) c([ b]) a4 g f2 b4\rest \bar"||"
  
  \time 2/4
  f4 ^\markup{\hspace #-2.0 \bold \box 3}
  f8 f f f g a b4 b b4\rest
  a8( b) c4 c8 c b4 a8 a \time 3/4 b4
  b4\rest a4 a a a8 a a4 a b a g g f b\rest
  \bar "|."
}

altMusic = \relative c'' {
  a4 a g f( g) a a a g8 g f4 f
  f f e f g f f e2
  a4 a f g8 a b4 a b a g g f2 b4\rest
  c,4 c e f2 f4 a8 g f4 e f f c4 f4 f f f e f
  f2 fis4 g g a8 g f4 f g8([ f]) e4 e f8( f)
  a([ g]) f4 e c2 b'4\rest
  f4 f8 f f f f f f4 f b4\rest
  f8( f) f4 f8 f f4 f8 f f4 b\rest
  f4 f f f8 f f4 f f f e e f b\rest  
}

tenorMusic = \relative c' {
  c4 c c c2 c4 c c c8 c c4 c
  c c c c c c c c2
  c4 c c c8 c b4 c d e d d c2 d,4\rest
  f4 f g a2 a4 c8 c c4 b a a
  a a a g f g a b2 a4 g d' c8 c f,8([ a])
  c4 c c c c d c b a2 d,4\rest  
  a'4 a8 a a a b c d4 d d,4\rest
  c'8 d es4 es8 es d4 c8 c d4 d,4\rest
  c'4 c c c8 c c4 c d c b b a d,\rest
}

bassMusic = \relative c {
  f4 f f f2 f4 f f c8 c f4 f f4 f c f e f f c2
  f4 f f f8 f b,8([ c]) d([ e])
  b4 c c c f2 d4\rest
  %\key g \major
  \transpose a g {
   \relative c' {
    g4 g d g2 g4 g8 g g4 d g g
    g4 g g g g fis g c,2
    e4 a c, d8 d g8([ h]) g4
    a,8([ h]) d4 d g c,8( d) d4 d <g g,>2 d4\rest
    }
  }
  f4 f8 f f f d c b4 b d4\rest
  f8( f) f4 f8 f f4 f8 f b,4 d\rest
  f4 f f f8 f f4 f b, c c c f d\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \womenWords }
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 70
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}