\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 3\mm
  %ragged-right = ##f
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Hristos a înviat"
  subtitle = "(2 + 1 variante)"
  composer = "Al. Podoleanu (1846 - 1907)"
  arranger = \markup \center-column { "G. Musicescu (1847 - 1903)" \small
       "gr.-russ. Choral, 5. Ton" }
  %meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOff
  %\cadenzaOn
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Hris -- tos a în -- vi -- at din morți! 
  Cu moar -- tea pe moar -- te căl -- când 
  și ce -- lor din mor -- min -- te via -- ță dă -- ru -- in -- du -- le.
  
  Hris -- tos a în -- vi -- at __ din morți 
  cu moar -- tea pe moar -- te căl -- când 
  și ce -- lor din mor -- min -- te via -- ță dă -- ru -- in -- du -- le.
  
  Christ ist er -- stan -- den von den To -- ten,
  im __ To -- de be -- zwang Er den Tod,
  hat al -- len in den Grä -- bern
  das Le -- ben ge -- schenkt.
}

menWords = \womenWords


sopMusic = \relative c'' {
  \partial 8 c8 ^\markup{\hspace #-2.0 \bold \box 1}
  c4. b8 a4 b c4. b8 a4. \breathe 
  a8 a4 g8. a16 b4 a8. a16 g4.
  c8 c4. a8 b4 c d2 c4.
  c8( c4.) h8 c4 d c b a4. b8\rest \bar"||"
  \time 3/4
  \partial 4 g4 ^\markup{\hspace #-2.0 \bold \box 2}
  a2 g4 f( a) c c8([ b] a4) g f2
  a4 c c b a b c d2
  c4 b b c8 b a4 a b8([ a] g4) g
  a8 b c([ b] a4) g f4. \fermata b8\rest \bar"||"
  \time 2/4
  f4 ^\markup{\hspace #-2.0 \bold \box 3}
  f8 f f f g a b4 b b4\rest
  a8( b) c4 c8 c b4 a8 a \time 3/4 b4
  b4\rest a4 a a a8 a a4 a b a g g f b\rest  
  \bar "|."
}

altMusic = \relative c'' {
  a8 a4. g8 f4 g a4. g8 f4. f8 f4 e8. f16
  g4 f8. f16 e4. a8 a4. f8 g4 a f2
  a4. a8( a4.) gis8 a4 b a g f4. b8\rest
  e,4 c2 e4 f2 f4 a8([ g] f4) e f2 c4 f4 f f f e f
  f2 fis4 g g a8 g f4 e g8([ f] e4) e f8 f a([ g] f4) e c4. b'8\rest
  f4 f8 f f f f f f4 f b4\rest
  f8( f) f4 f8 f f4 f8 f f4 b\rest
  f4 f f f8 f f4 f f f e e f b\rest 
}

tenorMusic = \relative c' {
  c8 c4. c8 c4 c c4. c8 c4. c8 c4 c8. c16
  c4 c8. c16 c4. c8 c4. c8 c4 c b2
  c4. c8( c4.) d8 c4 f c e c4. d,8\rest
  c'4 f,2 g4 a2 a4 c2 b4 a2 f4 a a g f g a 
  b2 a4 g d' c8 c f,([ a]) c4 c c c c8 c d4( c) b a4. d,8\rest
  a'4 a8 a a a b c d4 d d,4\rest
  c'8 d es4 es8 es d4 c8 c d4 d,4\rest
  c'4 c c c8 c c4 c d c b b a d,\rest
}

bassMusic = \relative c {
  f8
  f4. f8 f4 f f4. c8 f4. 
  f8 f4 c8. f16 e4 f8. f16 c4.
  f8 f4. f8 f4 f b,8([ c d e]) f4.
  f8( f4.) f8 f4 b, c c f4. d8\rest
  %\key g \major
  \time 3/4
  \partial 4 g4
  f2 c4 f2 f4 f2 c4 f2
  f4 f f f f e f b,2
  d4 g b, c8 c f8([a]) f4
  g,8([ a] c4) c f8 f b,4( c) c <f f,>4. d8\rest
  f4 f8 f f f d c b4 b d4\rest
  f8( f) f4 f8 f f4 f8 f b,4 d\rest
  f4 f f f8 f f4 f b, c c c f d\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \womenWords }
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
      >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 55
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}