\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Gesegnet sei"
  subtitle = "1. Ton"
  %subsubtitle = "glasurile 8, 1"
  composer =  "nach N. Lungu"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key d \minor
  %\autoBeamOff
  %\time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  \skip 4 \skip 1 \skip 1 \skip 1 \skip 1 
  Gott \skip 4 ist der "Herr__________________"
  \skip 4 \skip 4 \skip 4 \skip 2
  und ist uns er -- schie -- \skip 4 nen.
}

womenWords = \lyricmode {
  Ge -- seg -- net sei, Der da kommt 
  im __ Na -- men des Herrn.

  Gott ist der Herr und ist uns er -- schie -- nen.
}

menWords = \lyricmode {
  Ge -- seg -- net sei, Der da kommt 
  im __ Na -- men des Herrn.

  Gott ist der Herr __ und ist uns er -- schie -- nen.
}

sopMusic = \relative c' {
  f4^\mf a g g2 f4 f g2 f4( g) a( g) f e d2 \breathe 
  %f2 g4 a b1( b b2) a4 g f g e( f) d2.
  f2 g4 a b1( b2) a4 g f g e( f) d2.
  %d2 d4 e f2 e4 f a g f( e) d2.
  
  \bar "|."
}

altMusic = \relative c' {
  f4 a g g2 f4 f e2 f4( e) f( e) d c d2
  %r1 f2 g4 a \hide b1( b2) a4 g f e e( d) d2.
  r1 f2 g4 a b2 a4 g f e e( d) d2.
  %d2 d4 e f2 e4 f f e d( e) d2.
}

tenorMusic = \relative c {
  f4 a g g2 f4 f g2 a4( b) c2 c4 c d2
  r1 f,2 g4 a b2 c4 b a g g( f) d2.
}

bassMusic = \relative c {
  f4 a g g2 f4 f c2 d4( e) f( g) f e d2
  %r1 r f2 g4 a b2 a4 g f c a2 d2.
  r2 c2 d4 e f2( f) a4 g f c a2 d2.
  %d2 d4 c f2 e4 d c c c2 d2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}