\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 23))
  %markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 6\mm
  %ragged-right = ##f
  ragged-last-bottom=##f
  %system-count = #10
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Wahrhaft würdig"
  %subtitle = "”Cuvine-se cu adevărat”"
  composer =  \markup \center-column { "nach Gheorghe Dima (1847 - 1925)"
  \small "altes Kirchenlied aus Transsylvanien" }
  meter = "Andante"
  tagline=""
}

global = {
  \key g \major
  %\time 2/4
  \partial 2.
  %\override Staff.TimeSignature.stencil = ##f
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
  %\cadenzaOn
}

sopWords = \lyricmode {
  Wahr -- haft wür -- dig ist es, Dich zu prei -- sen,
  se -- lig, Got -- tes -- ge -- bä -- re -- rin,
  all -- zeit, e -- wig -- lich Se -- li -- ge
  und Ma -- kel -- lo -- se und Mut -- ter
  un -- se -- res Got -- tes.
  Die du bist ge -- ehr -- ter als die Che -- ru -- bim __
  und un -- ver -- gleich -- lich herr -- li -- cher
  als die Se -- ra -- phim;
  un -- ver -- sehrt, un -- ver -- sehrt __
  Du Gott, das Wort, ge -- bo -- ren hast;
  Dich, wahr -- haft, wahr -- haft 
  Got -- tes -- ge -- bä -- re -- rin
  prei -- sen __ wir.
}

sopMusic = \relative c'' {
  d2^\p
  d4 h d c( h) a2 \breathe
  g4^\< a h\!( c^\>) d2 \breathe
  \partial 2 h4^\< c d4.\!( e8) d4 d^\> c4 c h2\! \breathe
  \bar"||"  
  \partial 2 h4^\p d d h c(^\< d) e4\! e d2^\> \breathe
  \partial 2 h\! d4( e d)^\< d c2\> h
  \bar"||"
  \partial 2 h4\rest \!
  h4^\mf d2( c4 d4)^\> \bar"" h2 \breathe \bar"|"
  g4(^\< a) \bar"" h( c) d( e) d4( c8\![ h] c4^\> d) \bar"" \partial 2 h2\! 
  \bar"||"
  d4^\f h c d e2 d 
  d4 e d d c2(^\> h) 
  \bar"||"
  h4\rest\! d4^\p h c \partial 2 a a 
  g4.(^\< a8 h4 c\! d) e d2^\> \partial 2 h4\! d c h a4( c \bar"" h2) \breathe 
  \bar"||"
  h4^\p d d( h) c^\< d e2(\! d)^\> \breathe
  \partial 2
  h2\!^\p g4^\< a h c d( e c)^\> d h2
  \bar"||"
  h4\rest\! h4^\mf d2( c4 h) \bar"" \partial 2 a2 \breathe
  e'2( d4 c) \bar"" \partial 2 h2 \breathe
  \bar"||"
  %d2(^\f e4^\< fis) g2^\ff d2 d4^\> d e( d)\! \breathe
  d2^\f e4^\< fis g^\ff g d2\! \breathe
  c2^\p^\<^\markup { \raise #4 \italic { ritard. } }
  c^\> <h d>2\! \fermata  
  \bar "|."
}

altMusic = \relative c'' {
  %h2 h4 h h a( g) fis2
  %g4 fis g( a) h2 
  %g4 a h4.( c8) h4
  %fis a a g2
  %g4 d d8[ e] g[ fis] e4( g) c8([ h]) c4 h2 r4
  r1*3/4 r1 r r r2 r1 r 
  g4 d d8([ e]) g( fis) e4( g) c8([ h]) c4 h2 r4
  g4 g8( fis e fis g a) h4 h( a) g2 h4\rest
  g a2( g4 fis) g2 g4( g) g( g) g( g) g( g a h) h2
  h4 g a h ais2 h h4 cis d h a2( g)
  h4\rest r1*3/4 r2 r1 r r2 r1 r2
  %g h a fis fis g4.( fis8 fis4 fis g) g g2 g4 g a g fis2( g)
  g4 d d8([ e] g[ fis]) e4 g c8([ h] c4 h2) r4
  g4 g4. fis8 e4 es d( c d) e8([ fis]) g2 h4\rest
  g4 a2( g) g fis( h4 a) g2 
  %h( c) c2 h g4 fis g( h)
  h c4 c c c h2 
  h4( a) g( a) g2  
}

tenorMusic = \relative c {
  d1*3/4\rest d1\rest d1\rest d1\rest d2\rest d1\rest
  d1\rest d2\rest d1\rest d1\rest d2\rest d1\rest d1\rest
  g2 g4( fis e d) g2
  h,4.( d8) g([ fis] e4) d( c) h( c8[ d] e4 fis) g2
  g4 g g g g2 g h4 ais h g g( fis g2)
  d1\rest d2\rest d1\rest d1\rest d2\rest
  d1\rest d1\rest d1\rest d1\rest d2\rest
  d1\rest d1\rest d2\rest g2 g4( fis e2) d2 c( h4 d) g2
  g2 g4 d d d g2 g4( fis) e( fis) g2 
}

bassMusic = \relative c {
  d1*3/4\rest d1\rest d1\rest d1\rest d2\rest d1\rest
  d1\rest d2\rest d1\rest d1\rest d2\rest d1\rest d1\rest
  r2 r1 r r r r2
  d4 g8([ fis]) e4 d cis2 d4( e8[ fis])
  g4 g, g8([ a]) h([ c]) d2( g,)
  d'1\rest d2\rest d1\rest d1\rest d2\rest
  d1\rest d1\rest d1\rest d1\rest d2\rest
  d1\rest d1\rest d2\rest
  r2 r1 r2 r1 r2   
  g,2 c4 a g g g2 d' d <d g,>    
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \global \voiceOne \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \sopWords }
     \new Voice { \global \voiceTwo \altMusic }
    >>
    
    \new Staff <<
     %\clef "G_8"
     \clef bass
     \new Voice { \global \voiceOne \tenorMusic }
     \new Voice { \global \voiceTwo \bassMusic }
     %\new Voice { \global \bassMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     %\addlyrics { \tenorWords }
     >>    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 80
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}