\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Gesehen haben wir"
  subtitle = "1. Ton"
  %subsubtitle = "Op. 21"
  %poet = "Vasile Militaru (1885 - 1959)"
  composer =  "nach N. Lungu"
  %arranger = "io"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOn
  %\cadenzaOn
  %\time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Ge -- se -- hen ha -- ben wir das wah -- re Licht,
  em -- pfan -- gen den himm -- li -- schen Geist.
  Ge -- fun -- den ha -- ben wir den wah -- ren Glau -- ben.
  Die un -- teil -- ba -- re Drei -- fal -- tig -- keit
  be -- ten wir an, denn er -- löst hat sie uns.
}

menWords = \womenWords

sopMusic = \relative c' {
  d4^\mf \partial 2 g g a( g) f( e)
  \partial 2 g f f8([ e] d4) e( f) d2
  b'4\rest d, e( f) g f e( f) e f g2 
  b4\rest f4 \partial 2 g a b( a) g( f) 
  g f f8([ e]) d4 e( f) d2  
  b'4\rest c, d( e) f e f g f e d2 
  c2 f4 e d2 \breathe d4 d g2 f e d \fermata 
  \bar "|."
}

altMusic = \relative c' {
  d4 g g a( g) f( e) e f f8([ e] d4) e( f)
  d2 b'4\rest d, e( f) g f e( f) e f g2 
  b4\rest f4 g a b( a) g( f) e f f8([ e]) d4 e( f) d2
  b'4\rest c, d( e) f e f g f e d2 
  c2 f4 e d2 d4 d e2 f c d 
}

tenorMusic = \relative c {
  d4 g g c( b) b( c) c c d2 d d d,4\rest
  d' e( f) g f e( d) c8( b) a4 g2 d4\rest
  %g g2 g4 g g2 d,4\rest
  f4 g a b( a) g( f) f f f f e2 d
  d4\rest c d( e) f e f g f e d2 c f4 e d2
  d4 d e2 f g a
}

bassMusic = \relative c {
  d4 g g f( g) f( c) c d d2 a d 
  d4\rest d e( d) g f e( f) e f g2 d4\rest
  f4 g a b( a) g( f) c d d d a2 d2
  d4\rest c d( e) f e f g f e d2 c f4 e d2
  d4 d c2 d c d
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 110
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}