\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 14))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Kommt, lasst uns anbeten"
  subtitle = "1. Ton"
  composer = "nach N. Lungu"
  meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  %\time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}

womenWords = \lyricmode {
  Kommt, lasst uns an -- be -- ten und nie -- der -- fal -- len
  vor Chri -- stus.
  Er -- ret -- te uns, Sohn Got -- tes, auf -- er -- stan -- den
  von den To -- ten, die wir Dir sin -- gen:
  Hal -- le -- lu -- ja. __
}

menWords = \lyricmode {
  Kommt, lasst uns an -- be -- ten und nie -- der -- fal -- len
  vor Chri -- stus.
  Er -- ret -- te uns, Sohn Got -- tes, auf -- er -- stan -- den
  von den To -- ten, die wir Dir sin -- gen:   
  Hal -- le -- lu' Hal -- le -- lu' -- ja.
}

sopMusic = \relative c'' {
  a4^\mf 
  d( c) b a g( f) g4. a8 g4 f f( e) d cis d d \bar"||"
  \break
  \partial 4 d4^\markup "schneller"
  g g f g a a 
  b4 a g g a b c2( b4 a) g4.
  d8 g4 g f( g) a2 f4^\markup "a tempo" f g2 d2( d d)^\fermata
  \bar "|."
}

altMusic = \relative c'' {
  a4 d( c) b a g( f) g4. a8 g4 f f( e) d cis d d
  d4 g g f e f f 
  g4 f e e f g a2( g4 f) e4.
  d8 g4 g f( e) f2 d4 d g2 d2( d d)
}

tenorMusic = \relative c' {
  a4 d( c) b a g( a) b4. a8 g4 f f( e) f8([ g]) a4 a a
  d,4 g g a b a a a b c c c d c1 c4.
  a8 b4 b c( b) a2 a4 a b2
  a4 a b2 a
}

bassMusic = \relative c' {
  a4 d( c) b a g( d) g4. a8 g4 f f( e) d8([ e]) f4 d d
  d4 g g f c f f 
  e4 f c c f e f2( e4 f) c4.
  d8 d4 d d( c) f2 r1 d4 d g2 d2  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \addlyrics { \menWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
     >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 100
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}