\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  system-system-spacing = #'((basic-distance . 23))
  %markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  %ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ektenie"
  subtitle = "(Variante)"
  composer = "nach N. Lungu"
  meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- men.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  
  Dir, o, Herr.
}

menWords = \womenWords

sopMusic = \relative c'' {
  %\cadenzaOn
  
  c2^\f c \bar "||"
  
  %a2^\f( g4 a bes2^\> c2) a2\! \bar "||"
  f,4^\markup{\hspace #-2.6 \bold \box 1}^\p 
  f^\< f8\! f^\> f4\! \bar "||"

  f4^\markup{\hspace #-2.0 \bold \box 2} 
  f^\<  g8\! g^\> f4\! \bar "||"
  
  a4^\markup{\hspace #-2.0 \bold \box 3} 
  a^\< b8\! b^\> a4\! \bar "||"
  
  c4^\markup{\hspace #-2.0 \bold \box 4} 
  c^\< d8\! d^\> c4\! \bar "||" 
  
  d8([^\markup{\hspace #-2.0 \bold \box 5}
  c]) b([^\< a]) g\! g^\> a4\! \bar "||"
  
  c4^\markup{\hspace #-2.0 \bold \box 6}
  b8(^\< a) g\! g^\> f4\! \bar "||"
  
  a4^\< g4^\> f\! b4\rest \bar "||"
  
  \bar "|."
}

altMusic = \relative c'' {
  a2 a
  %f2( e4 f g2 a) f2
  f4 f f8 f f4
  f4 f e8 e f4
  f4 f g8 g f4
  a4 a b8 b a4
  b8([ a]) g([ f]) e e f4
  a4 g8( f) e e f4
  f4 e f b4\rest
}

tenorMusic =  \relative c {
  f2 f
  %c2( c d4 c a2) c
  f4 f f8 g a4
  a4 a b8 b a4
  a4 b8( c8) d d c4
  c4 c b8 b a4
  b8([ a]) b( c) b b a4
  a4 b8([ a]) g g f4
  
  f f f d4\rest  
}

bassMusic =  \relative c {
  f2 f
  %c2( c d4 c a2) c
  f4 f f8 f f4
  f4 f c8 c f4
  f4 f e8 e f4
  f4 f <b b,>8 <b b,> f4
  b8([ a]) g([ f]) c c f4
  f4 e8( f) c c f4
  
  f4 c f d4\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}