\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Herr, errette die Frommen"
  subtitle = "8. Ton"
  composer = "nach N. Lungu"
  %meter = "Andante"
  tagline = ""
}

global = {
  \key f \major
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Herr, __ er -- ret -- te uns, er -- ret -- te die Gläu -- bi -- gen.
  Und __ er -- hö -- re uns, er -- hö -- re uns, __
  und __ er -- hö -- re __ uns, er -- hö -- re __ uns,
  er -- hö -- re __ uns.
}
menWords = \lyricmode {
  Herr, __ er -- ret -- te uns, er -- ret -- te die Gläu -- bi -- gen.
  Und __ er -- hö -- re uns, er -- hö -- re uns,
  und __ er -- hö -- re uns, er -- hö -- re uns,
  er -- hö -- re __ uns.
}  

sopMusic = \relative c' {
  g'4(^\p f) e( f) \bar "|"
  g4.( a8 g4) a f2 \bar "|" \break
  \partial 1
  g4.^\mf( b8) a4 g8 g \bar "|"
  f2 e f \fermata \bar ":|." \break
  \mark "Und erhöre uns"
  \partial 1 b2\rest
  f8([^\p g f]) g
  a4 b
  c4. \breathe c8^\mf
  d4^\< e\!
  f2^\f
  es4^\>( d c4.) b8\!^\mf
  a4^\> g8( a)
  f4.\! f8^\p g8^\<([ a]) 
  b8^\>([ a]) g4\! g^\pp f8^\markup "rall."([ e]) d([ e])
  f2\fermata \bar "|."
}

altMusic = \relative c' {
  g'4( f) e( f) g4.( a8 g4) a f2
  e4.( g8) f4 e8 e d2 e f 
  b2\rest
  f8([ g f]) g f4 g a4. a8 b4 b
  a( c) c( b a4.) g8 f4 e f4.
  f8 e8([ f]) g([ f]) e4 e f8([ e]) d([ e])
  f2  
}

tenorMusic = \relative c' {
  g4( f) e( f) g4.( a8 g4) a f2
  c'4.( c8) c4 c8 b a2 g f2
  r2 r a4^\markup"Er  -" b8^\markup "hö - re" b c4.
  c8 b4 b a2 a( a4) b c4 c c4. c8 c4 c b4 b a g f2  
}

bassMusic = \relative c' {
  g4( f) e( f) g4.( a8 g4) a f2
  c4.( c8) f4 c8 c d2 c f
  %Si ne auzi...
  f2~ f4 f
  f4 f
  f4. f8
  b4 g
  f2
  f( f4) g
  f4 c
  f4. f8
  c4 c c4 c
  f8([ e]) d([ c]) <f f,>2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}