\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #9
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "II. Antiphon"
  subtitle = "8. Ton"
  %subsubtitle = "Mărire... şi acum... Unule Născut"
  composer = "nach N. Lungu"
  meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOn
  %\cadenzaOn
  %\numericTimeSignature\time 4/4 
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- men.
  Eh -- re sei dem Va -- ter und dem Soh -- ne und dem Hei -- li -- gen Geist.
  
  Ein -- ge -- bo -- re -- ner Sohn, Wort __ Got -- tes, Un -- sterb -- li -- cher,
  der Du um un -- se -- res Hei -- les wil -- len Fleisch wur -- dest
  von der hei -- li -- gen Got -- tes -- ge -- bä -- re -- rin und 
  im -- mer -- wäh -- ren -- den Jung -- frau Ma -- ri -- a;
  der Du, oh -- ne Dich zu ver -- än -- dern, Mensch wur -- dest.
  ge -- kreu -- zigt, Chri -- stus, un -- ser 
  all -- mäch -- ti -- ger Gott, im To -- de
  be -- zwan -- gest Du den Tod. Ei -- ner in der Hei -- li -- gen 
  Drei -- fal -- tig -- keit, gleich ver -- herr -- licht __ mit dem Va -- ter 
  und dem Hei -- li -- gen Geist, er -- lö -- se uns, o, Herr,
  er -- lö -- se __ uns.
}


menWords = \lyricmode {
  \skip 1 \skip 1 
  Jetzt und im -- mer -- dar und in al -- le E -- wig -- keit. A -- men.
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  %şi toa -- te ce -- le
 
}
  
sopMusic = \relative c'' {
  c2^\mf c2 \fermata \bar "||"
  c4^\< c c d\!
  es^\accent d c d
  c^\accent c a a
  c(^\accent b)^\> a g f2\!
  h2\rest h1\rest h1\rest h1\rest h1\rest
  %h2\rest  h2\rest  h2\rest h2\rest
  \bar "||"
  f4 e f g8 g a4( b) c( d) c c h4\rest
  f g^\> a f2\!
  f4( e) f^\< g a2\! a4 a f4 e f g a(^\< b) c(\! b^\>) a2
  a4\! g a( b) c d es( d) c c c d c2( c4) \breathe
  c d c b a8 a b4( a) g f g( a) f2
  b4^\accent b a4 g a b8 b c4 b a( b) c2 c4 \breathe
  b c d es d c d^\< e f\! es d^\> c2.\! \breathe
  c4^\mf c2^\accent a4 a c^\accent b a g f2
  b4 b \partial 2 a b c b a b c d c2
  \partial 2 c4 d e f es d c d es d c( b) a b c2^\fermata
  h4\rest c d c b^\> a g2.\!
  g4^\p f(^\markup"rall..." e) d( e) f2.^\fermata
  
  \bar "|."
}

altMusic = \relative c'' {
  a2 a a4 a a b c b a b a a f f a( g) f e f2
  h2\rest h1\rest h1\rest h1\rest h1\rest
  %h2\rest  h2\rest  h2\rest h2\rest
  f4 e f g8 g a4( b) a( b) a a h4\rest
  f e e f2
  f4( e) f g f2 f4 f f e f g a( b) a( g) f2
  f4 e f( g) a b c( b) a a a b a2( a4)
  a b a g f8 f g4( f) e f e2 f
  b4 b a g f g8 g a4 g f( g) a2 a4
  g a b c b c c c c c4 b a2.
  a4 a2 f4 f a g f e f2
  b4 b a b a g f g a b a2
  a4 b c c c b a b c b a( g) f g a2
  h4\rest a4 b a g f g2. g4 f( e) d( e) f2.
}

tenorMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d1\rest d1\rest d1\rest d1\rest d2\rest
  c'4 d es d c2 c4 c a a c b a( g) \breathe f2 f
  
  f4 g a b8 b c2 c4( d) c c d,4\rest c'4 c b a2
  a4( g) a b c2 c4 c c c c d c2 c c
  d,2\rest d1\rest d1\rest d1\rest \partial 2 d4\rest
  c'4 d c c c8 c c2 b4 a b2 a b4 b c c4 c d8 d es4 d c( d) c2 c4
  d,4\rest d2\rest d1\rest d1\rest d1*3/4\rest
  c'4 c2 c4 c c b a g f2 b4 b c b c d c c c c c2
  c4 d e f f f f f f f f( f) f f f2 d,4\rest c' d c b a g2.
  g4 f( e) d( b') a2.
} 

bassMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d1\rest d1\rest d1\rest d1\rest d2\rest
  a'4 b c b a2 a4 a f f a g f( e)
  f2 f
  
  f4 e d c8 c f2 e2 f4 f d4\rest f c c f2
  f4( e) d c f2 f4 f f4 e d c f( g) a( g) f2
  d2\rest d1\rest d1\rest d1\rest d4\rest
  f b a g f8 f c2 c4 c c2 f
  b4 b a g f f8 f f4 c f2 f f4
  d4\rest d2\rest d1\rest d1\rest d1*3/4\rest
  f4 f2 f4 f a g f c f2 
  b4 b a b a g f c f f f2
  c'4 c c c a b f f f f f( c) f f f2
  d4\rest f4 b a g f g2. g4 f( e) d( c) <f f,>2. 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
     >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 110
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
