\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "I. Antiphon"
  subtitle = "8. Ton"
  composer = "nach N. Lungu"
  meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOff
  %\cadenzaOn
  %\numericTimeSignature\time 4/4 
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- men.
  Eh -- re sei dem Va -- ter und dem Soh -- ne und dem Hei -- li -- gen Geist.
    
  Lo -- be den Herrn, __ mei -- ne See -- le, __
  und al -- les in mir sei -- nen hei -- li -- gen Na -- men. 
  Ge -- lobt __ seist Du, __ o, __ Herr.
}


menWords = \lyricmode {
  A -- men.
  Jetzt und im -- mer -- dar und in al -- le E -- wig -- keit. A -- men.
  Lo -- be den Herrn, __ mei -- ne See -- le, __
  und al -- les in mir sei -- nen hei -- li -- gen Na -- men. 
  Ge -- lobt seist Du, o, Herr.
 
  
}
  
sopMusic = \relative c'' {
  c2^\mf c2 \fermata \bar "||"
  %\time 2/4
  c4^\< c c d\!
  es^\accent d c d
  c^\accent c a a
  c(^\accent b)^\> a g f2\!
  h2\rest h1\rest h1\rest h1\rest h1\rest  
  \bar "||"
  a4(^\mp g) a b c( d c2) b4 a g( a)
  f2~ f4 f b a c b a b c^\< d8 d es4\!( d) c2^\fermata b4\rest
  c4^\p d^\accent( c8 d) c4( b)
  b(^\markup "rall." a) g8(^\> a g4)
  f2\fermata\! \bar "|."
}

altMusic = \relative c'' {
  a2 a a4 a a b c b a b a a f f a( g) f e f2
  h2\rest h1\rest h1\rest h1\rest h1\rest
  f4( e) f g a( b a2) b4 a e2 f2~ f4
  f b a a g f g a b8 b c4( b) a2 b4\rest
  a4 b4( a8 b) a4( g) g( f) e8( f e4) f2
}

tenorMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d1\rest d1\rest d1\rest d1\rest d2\rest
  
  c'4 d es d c2 c4 c a a c b a( g) \breathe f2 f
  c'4( c) c c c( b a2) b4 c c2 c2( c4)
  c d c c c c c c d8 d c4( b) a2
  d,4\rest r2 b'4^\markup "Ge   -" b^\markup "lobt" 
  b^\markup "seist" c2 b8( a g4) f2
}

bassMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d1\rest d1\rest d1\rest d1\rest d2\rest
  a'4 b c b a2 a4 a f f a g f( e)
  f2 f
  f4( e) d c f2( f) b4 a c,2 f2~ f4
  f b a a g f f f f8 f c2 f 
  d4\rest f4 b2 f2 c c f  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
     >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 110
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}