\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 17))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #12
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Heruvic"
  subtitle = " "
  composer = \markup \center-column {"după Marius Cuteanu" 
  \small "(1917 - 2013)" } 
  %meter = "Adagio"
  tagline=""
}

global = {
  \key c \major
  %\autoBeamOff
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Noi, __ ca -- re, __ 
  ca -- re pe __ he -- ru -- vimi
  cu __ tai -- nă în -- chi -- pu -- im,
  cu tai -- nă în -- chi -- pu -- im.
  
  Şi fă -- că -- toa -- rei de vi -- a -- ţă 
  de vi -- a -- ţă  Tre -- imi __
  în -- tre -- it __ sfân -- tă cân -- ta -- re a -- du -- cem.
    
  Toa -- tă __ gri -- ja cea __ lu -- meas -- că,
  de la noi să o le -- pă -- dăm, 
  de la __ noi s-o le -- pă -- dăm,
  să o le -- pă -- dăm, le -- pă -- dăm.  
}

menWords = \lyricmode {
  A -- min.
  Noi, __ ca -- re, 
  ca -- re pe he -- ru -- vimi
  cu __ tai -- nă în -- chi -- pu -- im,
  cu tai -- nă în -- chi -- pu -- im.

  Şi fă -- că -- toa -- rei de vi -- a -- ţă
  de vi -- a -- ţă  Tre -- imi __
  în -- tre -- it __ sfân -- tă cân -- ta -- re a -- du -- cem.
    
  Toa -- tă gri -- ja cea lu -- meas -- că,
  de la noi să o le -- pă -- dăm, 
  de __ la __ noi s-o le -- pă -- dăm,
  să o le -- pă -- dăm. __  
}

sopMusic = \relative c' {
  c2 c \bar"||"
  c2( e4 g) c2 h4( d) c( a) a2
  g2( f4 e) f2( g4) f e2. h'4\rest
  \partial 2 h4( c) d2 d4 d c d e2
  f2 e4( d) c e d c8( h) c2. h4\rest
  \bar"||"
  c2 h4 d c( a) a2 g( f4) e f2( g4 f) e2. h'4\rest
  \partial 2 h4 c d2 d4 d c( d e2) f4 f e( d) c( e) d c
  h4( d) a h c2 c4 h4\rest 
  \bar"||" 
  c2 h4( d) c( a) a2
  g2( f4) e f2( g4 f) e2. h'4\rest
  \partial 2 h4 c d2 d4 d c d e2 f e4( d) c e d c8( h)
  c2. h4\rest g4 g a h c1~ c  
  \bar "|."
}

altMusic = \relative c' {
  c2 c
  c2( e4 g) g2 g4( f) e( f) f2
  e2( d4 c) d2( h4) d c2. h'4\rest
  g2 g g4 g g g g2 a a g4 g g g g2. h4\rest
  g2 g4 f e( f) f2 e( d4) c d2( h4 d) c2. h'4\rest
  g4 g g2 g4 g g2( g) a4 a a2 g2 g4 g g2 a4 g 
  g2 g4 h4\rest
  g2 g4( f) e( f) f2
  e2( d4) c d2( h4 d) c2. h'4\rest
  g4 g g2 g4 g g g g2 a a g4 g g g
  g2. h4\rest g4 g f f e2 f4 f e1
  
}

tenorMusic = \relative c {
  c2 c
  c2 e4( g) g2 g c c \hide \once g1 g2. g4 g2. d4\rest
  d'4( c) h2 h4 h c h c2 c4( d) cis( d)
  e c f f e2. d,4\rest
  g2 g4 g c2 c g2. g4 g1 g2. d4\rest
  d'4 c h2 h4 h c( h) c2 c4 d cis( d) e( c) f e
  d4( f) f f e2 e4 d,4\rest g2 g c c 
  g2. g4 g1 g2. d4\rest
  d'4 c h2 h4 h c h c2 c4( d) cis( d) e c f f
  e2. d,4\rest g4 g g g g2 as4 as g1  
}

bassMusic = \relative c {
  c2 c
  c2( e4 g) c,2 c c f g1 g,2. g4 c2. d4\rest
  %d4( c) h2 h4 h c h c2
  f4( e) g2 f4 f e d c2 
  f4( d) e( f) 
  g g g, g c2. d4\rest
   c2 c4 c c2 f g2. g4 g,1 c2. d4\rest
  f4 e g2 f4 f e( d c2) f4 d e( f) g2 g4 g
  g,2 g4 g c2 c4 d4\rest c2 c c f g2. g4 
  g,1 c2. d4\rest
  f4 e g2 f4 f e d c2 f4( d) e( f) g g g, g
  c2. d4\rest g4 g g g c,1~ c
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global\voiceOne \sopMusic }
      \new Voice { \global\voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \global\voiceOne \tenorMusic }
      \new Voice { \global\voiceTwo \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
