\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  system-system-spacing = #'((basic-distance . 23))
  %markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  %ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ectenia"
  subtitle = "(variantă)"
  composer = "după N. Lungu"
  meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  
  Ți -- e, Doam -- ne.
}

menWords = \womenWords

sopMusic = \relative c'' {
  %\cadenzaOn
  
  c2^\f c \bar "||"
  
  %a2^\f( g4 a bes2^\> c2) a2\! \bar "||"
  f,8^\markup{\hspace #-2.0 \bold \box 1}^\p 
  f f^\< f f4^\> f\! \bar "||"

  f8^\markup{\hspace #-2.0 \bold \box 2} 
  f f^\< f g4^\> f4\! \bar "||"
  
  a8^\markup{\hspace #-2.0 \bold \box 3} 
  a a^\< a b4^\> a\! \bar "||"
  
  c8^\markup{\hspace #-2.0 \bold \box 4} 
  c c^\< c d4^\> c\! \bar "||" 
  
  d8^\markup{\hspace #-2.0 \bold \box 5}
  c b^\< a g4^\> a\! \bar "||"
  
  c8^\markup{\hspace #-2.0 \bold \box 6}
  c b^\< a g4^\> f\! \bar "||"
  
  \partial 4
  a8^\< a g4^\> f\! \bar "||"
  
  \bar "|."
}

altMusic = \relative c'' {
  a2 a
  %f2( e4 f g2 a) f2
  f8 f f f f4 f
  f8 f f f e4 f
  f8 f f f g4 f
  a8 a a a b4 a
  b8 a g f e4 f
  a8 a g f e4 f
  f8 f e4 f
  
  
}

tenorMusic =  \relative c {
  f2 f
  %c2( c d4 c a2) c
  f8 f f f g4 a
  a8 a a a b4 a
  a8 a b c d4 c
  c8 c c c b4 a
  b8 a b c b4 a
  a8 a b a g4 f
  
  f8 f f4 f  
}

bassMusic = \relative c {
  f2 f
  %c2( c d4 c a2) c
  f8 f f f f4 f
  f8 f f f c4 f
  f8 f f f e4 f
  f8 f f f <b b,>4 f
  b8 a g f c4 f
  f8 f e f c4 f
  
  f8 f c4 f
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
    \tempo 4 = 90
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
