\version "2.24.0"
\language "deutsch"

\paper {
  %markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #8
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Antifonul al II-lea"
  subtitle = "Imnul lui Iustinian"
  subsubtitle = "Glas 8"
  composer = "arm. după N. Lungu"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOn
  %\cadenzaOn
  %\numericTimeSignature\time 4/4 
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Mă -- ri -- re Ta -- tă -- lui şi Fi -- u -- lui şi Sfân -- tu -- lui Duh.
  U -- nu -- le Năs -- cut, __ Fi -- u -- le şi Cu -- vân -- tul lui Dum -- ne -- zeu,
  Ce -- la ce eşti fă -- ră de moar -- te 
  şi __ ai pri -- mit, pen -- tru mân -- tu -- i -- rea noas -- tră, 
  a Te în -- tru -- pa din Sfân -- ta Năs -- că -- toa -- re de Dum -- ne -- zeu
  şi pu -- ru -- rea Fe -- cioa -- ră Ma -- ri -- a; 
  Ca -- re __ ne -- schim -- bat Te-ai în -- tru -- pat 
  şi răs -- tig -- nin -- du -- Te, Hris -- toa -- se Dum -- ne -- ze -- u -- le, 
  cu moar -- tea pe moar -- te ai căl -- cat. 
  U -- nul fi -- ind din Sfân -- ta Tre -- i -- me, 
  îm -- pre -- u -- nă mă -- rit cu Ta -- tăl şi cu Du -- hul Sfânt, 
  mân -- tu -- ieş -- te -- ne pe noi,
  mân -- tu -- ieş -- te -- ne pe noi.
}


menWords = \lyricmode {
  %\skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  %\skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 
  Şi a -- cum şi pu -- ru -- rea şi în ve -- cii ve -- ci -- lor, A -- min.
  U -- nu -- le Năs -- cut, Fi -- u -- le şi Cu -- vân -- tul lui Dum -- ne -- zeu,
  Ce -- la ce eşti fă -- ră de moar -- te 
  şi __ ai pri -- mit, pen -- tru mân -- tu -- i -- rea noas -- tră, 
  %a Te în -- tru -- pa din Sfân -- ta Năs -- că -- toa -- re de Dum -- ne -- zeu
  şi pu -- ru -- rea Fe -- cioa -- ră Ma -- ri -- a; 
  Ca -- re __ ne -- schim -- bat Te-ai în -- tru -- pat 
  %şi răs -- tig -- nin -- du -- Te, Hris -- toa -- se Dum -- ne -- ze -- u -- le, 
  cu moar -- tea pe moar -- te ai căl -- cat. 
  U -- nul fi -- ind din Sfân -- ta Tre -- i -- me, 
  îm -- pre -- u -- nă mă -- rit cu Ta -- tăl şi cu Du -- hul Sfânt, 
  mân -- tu -- ieş -- te -- ne pe noi,
  mân -- tu -- ieş -- te -- ne pe noi.
  
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  %şi toa -- te ce -- le
 
}
  
sopMusic = \relative c'' {
  c2^\mf c2 \fermata \bar "||"
  %\time 2/4
  \partial 2. c4^\< c d\!
  es^\accent d c d
  c^\accent c a a
  c(^\accent b)^\> a g f2\!
  h2\rest  h2\rest  h2\rest  h2\rest h2\rest
  h2\rest  h2\rest  h2\rest  h2\rest 
  \bar "||"
  f4 e f g a( b) c(^\accent b) a g a b c( d)
  c b a b c2 c g4 a b a g f g(^\> a) f2\!
  f4( e) f^\< g a2\! f4 e f g a^\< b c(\! b^\>) a2 
  a4\! g a b c d es d c c c( d) c b a b c2( c4) 
  c d c b a b( a) g f g( a) f2 
  b^\accent a4( g) a b c b a b c2( c4) \breathe
  b c d es d c^\> c d\! b c d^\< e( f\!) es( d^\>) c2( c4\!) \breathe
  c^\mf c2^\accent a4 a c^\accent b a g f2
  b a4 b c b a( g) a b c( d) c2
  c4 d e( f) es d c d es d c b a b c2^\fermata
  c4 c d c b^\> a g2\! 
  g4^\p g^\markup"rall..." f e d e f2^\fermata
  \bar "|."
}

altMusic = \relative c'' {
  a2 a a4 a b c b a b a a f f a( g) f e f2
  h2\rest  h2\rest  h2\rest h2\rest
  h2\rest  h2\rest  h2\rest  h2\rest h2\rest
  f4 e f g a( b) a( g) f e f g a( b) a g f g a2
  a g4 f g f e f e2 f
  f4( e) f g f2 f4 e f g a b a( g) f2
  f4 e f g a b c b a a a( b) a g f g a2( a4) 
  a b a g f g( f) e f e2 f b a4( g) f g a g f g a2( a4) 
  g a b c b a a b g c c c2 c4( b) a2( a4)
  a a2 f4 f a g f e f2
  b a4 b a g f( e) f g a( b) a2
  a4  b c2 c4 b a b c b a g f g a2
  a4 a b a g f g2 g4 g f e d e f2  
}

tenorMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d4\rest d2\rest d2\rest d2\rest
  d2\rest d2\rest d2\rest d2\rest d2\rest
  
  c'4 c c d es d c2 c4 c a a c b a \breathe g \hide f2
  f4 g a b c2 c4( d) c c c d c( b) c d c c c2
  c2 c4 c c c c c b2 a a4( g) a b c2 c4 c c c c d c2 c
  d,1\rest d1\rest d1\rest d1\rest d2\rest d4\rest
  c'4 d c c c c2 b4 a b2 a b c c4 d es d c d c2( c4)
  d,4\rest d2\rest d1\rest d1\rest d1\rest d2\rest d4\rest
  c'4 c2 c4 c c b a g f2 b2 c4 b c d c2 c4 c c( d) c2
  c4 d e( f) f f f f f f f f f f f2 c4 c d c b a g2
  g4 g f e d b' a2
}  

bassMusic = \relative c {
  f2 f
  %d4 d d g g d4. d8 d4 cis d g f( e) d a d2  
  d4\rest d2\rest d2\rest d2\rest
  d2\rest d2\rest d2\rest d2\rest d2\rest
  a'4 a a b c b a2 a4 a f f a g f e f2
 
  f4 e d c f2 f4( g) f c f f f2 f4 c f f f2 
  f e4 f c c c c c2 f
  f4( e) d c f2 f4 e d c f g a( g) f2
  d1\rest d1\rest d1\rest d1\rest d2\rest d4\rest
  f b a g f c2 c4 c c2 f 
  b a4( g) f f f c f f f2( f4) 
  d4\rest d2\rest d1\rest d1\rest d1\rest d2\rest d4\rest
  f4 f2 f4 f a g f c f2 
  b a4 b a g f( c) f f f2 f
  c'4 c c2 a4 b f f f f f c f f f2
  f4 f b a g f g2 g4 g f e d c <f f,>2
  
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
     >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 100
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
