\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 14))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  %ragged-right = ##t
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Mărire Ţie, Doamne"
  subtitle = "glasul 8"
  %subsubtitle = "Înainte de citirea din Evanghelie"
  composer =  \markup \center-column { "arm. după I. Alfeiev"  
  " N. Lungu / I. D. Chirescu" }
  %meter = "Maestoso"
  tagline = ""
}

global = {
  %#(set-global-staff-size 19)
  %\key f \major
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 2
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 4 \skip 4 \skip 4 \skip 4 \skip 4 \skip 4
  Mă -- ri -- \skip 4 re, 
}

altWords = \lyricmode {
  A -- li -- lu -- i -- a,
  A -- li -- lu -- i -- a,
  A -- li -- lu -- i -- a.  
  
  Și du -- hu -- lui tău.
  
  Mă -- ri -- re Ţi -- e, Doam -- ne, mă -- ri -- re Ţi -- e.
  
  Mă -- ri -- re Ţi -- e, Doam -- ne, mă -- ri -- re Ţi -- e.
  Mă -- ri -- re, mă -- ri -- re, mă -- ri -- re Ţi -- e,
  
}

menWords = \lyricmode {
  A -- li -- lu -- i -- a. 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
	
  
}
	
sopMusic = \relative c'' {
  \key g \major
  \partial 2
  g4^\markup \bold "Aliluia"
  g a fis g2 h4 h c a h2
  d4 d g( fis8 e d4 c) h2( a) g1 \bar"||"
  
  %\mark "                            Și duhului tău "
  \key f \major
  \partial 4 f4^\mf 
  a2 g4 g f2 \bar"||" 
  \partial 4 f4 ^\markup \large "Înainte de citirea din Evanghelie"
  %\mark "                                                    Înainte de citirea din Evanghelie"
  a a b a c2 c4 \breathe
  f,4 g a b2( g) f \bar"||" \break
  
  %\key c \major
  \time 4/4
  \key b \major
  \partial 4 f4 ^\markup \large "După citirea din Evanghelie"
  b a g f d'( c) b a g2 g4( a) b2 f4 \breathe r4 \break
  r b a( c) b \breathe d c( es) d
  b d c b2( c) d ^\fermata
  
  \bar "|."
}  
  
altMusic = \relative c'' {
  \key g \major
  g4 g a fis g2 g4 g a fis g2
  h4 h h( g2.) g2( fis) d1 \break
  
  \key f \major
  f4 f2 e4 e f2 ^\fermata \break
  f4 f f g f a2 a4 f e f d2( e) f ^\fermata
  f4 b a g f d'( c) b a g2 g4( a) b2 f4
  f4 f1 b4 b a( c) b b b a b2( a) b
}

bassMusic = \relative c' {
  \key g \major
  r2 r1 r
  g4 g g8( fis e d g,4 a h c) d1 <g g,>
  
  \key f \major
  f4 f2 c4 c f2
  f4 f f g f f2 f4 f e f b,2( c) f
  f4 b a g f b( a) g f es2 es b b4
  f'4 f1 f4 f f2 f4 g es c f2( f,) b 
}
 
myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     \new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \altWords }
     >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 90
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}