\version "2.24.0"
\language "deutsch"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 20))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Imnul mirilor"
  subtitle = "Vino din Liban, mireasă"
  composer =  \markup \center-column { "Gavriil Musicescu" \small 
  "(1847 – 1903)" }
  %meter = "Lento"
  tagline=""
}

global = {
  \key b \major
  %\autoBeamOff
  %\time 4/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Vi -- no, vi -- no din Li -- ban __ mi -- rea -- să,
  Vi -- no, vi -- no din Li -- ban __ mi -- rea -- să.
  Vi -- no, vi -- no, bu -- na mea;
  Vi -- no, vi -- no, de a -- proa -- pea mea;
  Vi -- no, po -- rum -- bi -- ţa mea.
  A -- ra -- tă-mi, a -- ra -- tă-mi fa -- ţa ta 
  şi mă fă __ să a -- ud __ gla -- sul tău;
  gla -- sul tău, gla -- sul tău e dul -- ce şi
  fa -- ţa ta şi fa -- ţa ta-i fru -- moa -- să.
}

menWords = \lyricmode {
  
}

sopMusic = \relative c'' {
  d4.^\mf c8 d[ d] d es f8.([ g16 f8]) es es d d4\rest
  c4. c8 c[ c] a b c8.([ d16 es8]) c d d d4\rest
  g2^\f f es d f8.^\p([ es16]) d8([ c]) d2
  g2^\f f es d f8^\p[ es] d c d2 e^\mf f4 f8 f f4 e f d8\rest
  \bar"||"
  \key f \major
  c8^\p c4.( a8) c4. f8 f([ e]) d([ c]) c b b4 
  b4. g8 b4.( d8) d c c([ b]) b8. a16 a4
  e'4.^\f e8 f2 f8. f16 f8 f e4 f8 f
  e4. e8 f4. f8 f4. f8 f4 f f( e) f2	
  \fermata
  \bar "|."
}

altMusic = \relative c'' {
  b4. a8 b[ b] b c d8.([ es16 d8]) c c b d4\rest
  a4. g8 a[ a] f g a8.([ b16 c8]) c b b d4\rest
  es2 d c b d8.([ c16]) b8([ a]) b2
  es d c b d8[ c] b a b2 c c4 d8 d c4 b a d8\rest
  \bar"||"
  \key f \major
  a8 a4.( f8) a4. a8 a([ c]) b([ a]) a g g4 
  g4. g8 g4.( b8) b a a([ g]) g8. f16 f4
  c'4. c8 c2 d8. d16 c8 c c4 c8 c
  c4. c8 c4. c8 d4. d8 c4 c b2 a  
}

bassMusic = \relative c' {
  b4. f8 b, b r4 r1
  f'4. c8 f[ f] f f f4. f8 b b, r4
  es8.([ f16 g8 es]) b'2 f b, f'4 f b,2
  es8.([ f16 g8 es]) b'2 f b, f'8[ f] f f
  b,2 g' f4 b,8 b c4 c f r8
  \bar"||"
  \key f \major
  f8 f2 f4. f8 f4 f fis8 g c,4 c4. c8 
  c2 c8 c c4 e8. f16 f4
  g4. g8 f2 b8. b16 c8 c c,4 f8 f
  c4. c8 f4. f8 b,4. b8 c4 c c2 <f f,>
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \transpose b g
      \new Voice { \global \voiceOne \sopMusic }
      \transpose b g
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      \transpose b g
      %\new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 75
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \transpose b g
  \myScore
  \midi { \midiOutput }
}

\score {
  \transpose b g
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \transpose b g
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \transpose b g
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
