\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 23))
  system-system-spacing = #'((basic-distance . 17))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ectenia mare"
  subtitle = "Slujba Logodnei"
  %subsubtitle = "Ectenia mare (gl.8)... Mărire Ție, Dumnezeul nostru..."
  composer = "după N. Lungu / Gh. Cucu"
  meter = "Andante"
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- men.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich.
  
  All -- hei -- li -- ge Got -- tes -- ge -- bä -- re -- rin, 
  er -- ret -- te uns.
  Dir, o, Herr.
}

menWords = \womenWords

sopMusic = \relative c'' {
  %\cadenzaOn
  
  %a2^\f a \bar "||"
  %a4^\mf^\<( b) a4\!^\fermata b4\rest \bar"||"
  a4^\mf^\<( b g)\! a^\fermata \bar"||"
  
  
  %a2^\f( g4 a bes2^\> c2) a2\! \bar "||"

  a4^\markup{\hspace #-2.0 \bold \box 1}^\p 
  g8(^\< f)\! g4 a^\> f4. h8\rest\! \bar "||"
  
  a4^\markup{\hspace #-2.0 \bold \box 2} 
  g8(^\< a)\! b4 c^\> a4. h8\rest\! \bar "||"
  
  c8(^\markup{\hspace #-2.0 \bold \box 3} 
  a) b(^\< c)\! d4 d^\> c4. h8\rest\! \bar "||" 
  
  f'4^\markup{\hspace #-2.0 \bold \box 4}
  e8(^\< d)\! d4 d^\> c4. h8\rest\! \bar "||" 
  
  d8(^\markup{\hspace #-2.0 \bold \box 5}
  c) b(^\< a)\! b4 c^\> a4. h8\rest\! \bar "||"
  
  c4^\markup{\hspace #-2.0 \bold \box 6}
  g8( a) b4 g^\> f4. h8\rest\! \bar "||"
  b8\rest a8^\mf^\markup \bold "Allheilige..."
  \times 2/3 { c8 c c }
  f4 e8 e d d c4 b8\rest 
  d c4 b8 a4 b8\rest \bar "||"
  a4^\<^\accent^\markup \bold "Dir, o Herr" 
  g^\> f4 h4\rest\!  
  \bar "|."
}

altMusic = \relative c' {
  %f2 f
  %f4.( e8) f4 b4\rest
  f4( e e) f4
  %f2( e4 f g2 a) f2
  f4 e8( f) e4 e f4. h8\rest
  f4 e8( f) g4 a f4. h8\rest
  a8( f) g( a) b4 b a4. h8\rest
  f8( a) c( b) b4 b a4. h8\rest
  b8( a) g( f) g4 a f4. h8\rest
  a4 g8( f) d4 e f4. h8\rest
  
  b8\rest f8 \times 2/3 { a8 a a}
  a4 a8 a b b a4 b8\rest
  g8 g4 g8 f4 b8\rest
  
  f4 e f h4\rest  
}

bassMusic =  \relative c {
  %f2 f
  %f8([ d b c]) <f f,>4 r
  f4(b, c) <f f,>
  %c2( c d4 c a2) c
  f4 e8( f) c4 c f4. d8\rest
  f4 e8( f) b,4 c f4. d8\rest
  f4 f <b b,> <b b,> f4. d8\rest
  f8( a) c( b) b4 b f4. d8\rest
  b'8( a) g( f) b,4 c f4. d8\rest
  f4 e8( f) b,4 c f4. d8\rest
  
  d8\rest f8 \times 2/3 { f8 f f} 
  d4 c8 c b b f'4 r8
  g8 e4 e8 f4 d8\rest
  
  f4 c <f f,> d4\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      \new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
