\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 13))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
 title = "Christi Leib"
  subtitle = "8. Ton"
  %composer =  \markup \center-column { "Gheorghe Cucu" \small 
  %"(1882–1932)" }
  %meter = "Andante"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOff
  %\cadenzaOn
  %\time 2/4
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 2.
  trin -- "ket.________"
}  

womenWords = \lyricmode {
  Chri -- sti Leib em -- pfan -- get, em -- pfan -- get,
  und aus der Quel -- le der Un -- sterb -- lich -- keit __
  ko -- stet, ko -- stet.
  
  Chri -- sti Leib em -- pfan -- get, em -- pfan -- get,
  und aus der Quel -- le der Un -- sterb -- lich -- keit __
  ko -- stet.
  
  Hal -- le -- lu -- ja,
  hal -- le -- lu -- ja,
  hal -- le -- lu -- ja.
}

menWords = \lyricmode {
  Chri -- sti Leib em -- pfan -- get, em -- pfan -- get,
  und aus der Quel -- le der Un -- sterb -- lich -- keit
  ko -- stet. __
  und aus der Quel -- le der Un -- sterb -- lich -- keit __
  ko -- stet.
  Hal -- le -- lu -- ja,
  hal -- le -- lu -- ja,
  hal -- le -- lu -- ja.
}

sopMusic = \relative c'' {
  % Trupul lui Hristos primiţi şi din izvorul cel fără de moarte gustaţi.
  a4^\p g4 f4 e4^\<  f4( g4\!) f4^\> e4 \bar "|"
  d4.(\! f8 e4^\> d4)\! c4. \breathe
  c8 f4^\< g4 a4(\! b4) g2 c4 b4^\> a4 g4\! 
  a8([^\< b8\! a8^\> g8)] f4(\! e4 )f2( f4.) b8\rest \bar"||"
  % Trupul lui Hristos primiţi şi din izvorul cel fără de moarte gustaţi.
  c4 a b8 c d4 c2 b8([ a]) c( b) a2 
  b8\rest a8 b c d4 c es d c b a8([ b c d] c2) 
  b8([ a] g4) a ^\fermata b4\rest \bar "||"
  
  % Aliluia, aliluia, aliluia.
  f4^\mf^\< f4 \bar "|"
  g8([\! a8] g4 f4^\> e8[ f8)] \bar "|"
  d2\! \breathe f4^\< f4 \bar "|"
  g8([\! a8] b4 a4^\> g8[ a8)] \bar "|"
  f2\! d4^\< c4\! \bar "|"
  a'4(^\accent g4 f4^\> e4)\!
  f2 \fermata 
  \bar "|."
}

altMusic = \relative c' {
  f4 e f e f( e) f e d4.( f8 e4 d4) c4.
  c8 f4 e f2 e2 f4 g a g f4.( e8) c4( c) c d c4. b'8\rest
  a4 f g8 a b4 a2 g8([ f]) a( g) f2 
  b8\rest f8 g a b4 a c b a g f4.( g8 a2)
  g8([ f] e4) f b4\rest
  f4 f e8([ f] e4 d4 e8[ f]) d2
  d4 d e8([ f] g4 f e) f2
  d4 c f( e f c) c2
}

tenorMusic = \relative c' {
  c4 c a a a( b) a4. g8 f2( g4 f) e4.
  c'8 c4 c c2 c c4 c c d 
  c4.( b8) a4( g) a b a4. d,8\rest
  d2\rest d2\rest d2\rest 
  %d2\rest d2\rest 
  g8([ a]) a( b) c2
  d,8\rest f f f f4 c' c c c c c4.( b8 a2) c2 c4 d,4\rest
  f4 f f2( f) f
  f4 f e2( f4 g) a2
  b4 a c( b a g) f2
}

bassMusic = \relative c {
  % Trupul lui Hristos primiţi şi din izvorul cel fără de moarte gustaţi.
  f4 c4 d4 %d d2 d4( a4)
  a4 b( g) c c
  d2( a4 b)
  c4. b'8
  a4 g4
  f2 c4( b'4)
  a4 g4 f4 b,4
  c2 c4( c4) f2( f4.) d8\rest
  
  % Trupul lui Hristos primiţi şi din izvorul cel fără de moarte gustaţi.
  %a4 f g8 a b b f2 g8([ f]) a g f2 
  d2\rest d2\rest d2\rest d2\rest d2\rest 
  d8\rest f f f f4 f c d c e f2( f) c2 f4 d4\rest  %r8 f8 g a b4 a c b a g f g a g g8([ f] e4 f2.) r4
  
  % Aliluia, aliluia, aliluia.
  f4 f4
  c2( d4 a4)
  d2 d4 d4
  c2( f2) f 
  b4 a4 c2( c,) f  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     \new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \womenWords }
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 50
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}