\version "2.24.0"
\language "deutsch"


\paper {
  %between-system-padding = 0\mm
  %markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.1\cm
  line-width = 19.2\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 3\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Heiliger Gott"
  subtitle = "Trisagion"
  subsubtitle = "(Variante)"
  composer = \markup \center-column { "Gheorghe Ștephănescu"  
  "Gavriil Musicescu" } 
  tagline=""
}

global = {
  \key g \major
  %\autoBeamOff
  %\time 3/4 
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- men.
  Hei -- li -- ger, hei -- li -- ger Gott,
  Hei -- li -- ger Star -- ker,
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
  
  \once \override LyricText.self-alignment-X = #-1
  "Ehre sei dem Vater und dem Sohne und dem Heiligen" 
  \once \override LyricText.self-alignment-X = #-1
  Geist. 
  \once \override LyricText.self-alignment-X = #-1
  "Jetzt und immerdar und in alle Ewigkeit." 
  \once \override LyricText.self-alignment-X = #-1
  A -- men.
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
  
  Hei -- li -- ger, hei -- li -- ger Gott,
  Hei -- li -- ger Star -- ker,
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- barm' Dich un -- ser.
}

menWords = \lyricmode {

}

sopMusic = \relative c'' {
  g2^\mf h \bar "||"
  \time 3/4
  h4.^\p a8 g([ h]) d4 c8 c h4
  a4. h8 c([ a])
  \time 2/4
  h8.( c16) d4
  \time 3/4
  d4.^\< h8[ c] d e4.^\> d8[ c] h a4.\!
  h8 c([ d])  h4 h h4\rest
  \bar ":|." %\break
  
  %g\breve 
  \mark "                              Ehre sei dem Vater"
  
  \cadenzaOn
  d\breve \bar"|" e2 \bar"|" e\breve \bar"|" d4 d \bar"|"
  %\time 3/4
  \cadenzaOff
  d4. h8[ c] d e4. d8[ c] h a4. h8 c([ d]) h4 h h4\rest
  \bar "|." %\break
  
  
  \mark "           Stärker"
  h4^\p h h d4 c h a2.
  c4 c c e4( d c) h2.
  d4. d8[ d] g fis4. e8[ d] c
  h4( a) h d( c a) h2 \fermata h4\rest
  
  \bar "|."
}

altMusic = \relative c'' {
  g2 g
  g4. fis8 g([ g]) h4 a8 a g4 fis4. g8 a([ fis])
  \time 2/4 g8.( a16) h4
  \time 3/4
  h4. g8[ a] h c4. h8[ a] g fis4. g8 a([ h]) g4 g h4\rest  
  
  h\breve c2 c\breve h4 h
  h4. g8[ a] h c4. h8[ a] g fis4. g8 a([ h]) g4 g h4\rest  

  g4 g g h4 a g fis2. a4 a a c( h a) g2.
  h4. h8[ h] e d4. c8[ h] a g4( fis) g h( a fis) g2 h4\rest
}

tenorMusic = \relative c' {
  g2 g
  g4. d8 h([ d]) g4 d8 d g4 d4. d8 d([ d])
  \time 2/4 g4 g
  \time 3/4
  g4. fis8[ e] g g4. g8[ d] d d4. d8 d([ d]) g4 g d4\rest 
  
  g\breve \bar"|" g2 \bar"|" g\breve \bar"|" g4 g
  
  g4. fis8[ e] g g4. g8[ d] d d4. d8 d([ d]) g4 g d4\rest 

  g4 g g g g g d2. d4 d d g2. g
  g4. g8[ g] g a4. a8[ fis] fis  
  g4( d) g g( d d) g2 d4\rest 

}

bassMusic = \relative c' {
  g2 g
  g4. d8 h([ d]) g4 d8 d g4 d4. d8 d([ d])
  \time 2/4 g4 g
  \time 3/4
  g4. fis8[ e] d c4. h8[ a] g 
  d'4. d8 d([ d]) g,4 g d'4\rest   
  
  g,\breve \bar"|" c2 \bar"|" c\breve \bar"|" g4 g  
  
  g'4. fis8[ e] d c4. h8[ a] g 
  d'4. d8 d([ d]) g,4 g d'4\rest 
   
  g4 g g g g g4
  d2. d4 d d c4( d e8[ fis]) g2.
  g4. g8[ g] g d4. e8[ fis] fis 
  g4( d) g g( d d) g,2 d'4\rest
}


myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}