\version "2.24.0"
\language "deutsch"


\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #8
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Heiliger Gott"
  subtitle = "Trisagion"
  subsubtitle = "5. Ton"
  composer = "nach N. Lungu"
  %arranger = "arm. după N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  \autoBeamOn
  \key f \major
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- men.
  Hei -- li -- ger Gott, __
  Hei -- li -- ger Star -- ker,
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
  
  Eh -- re sei dem Va -- ter und dem Soh -- ne und dem Hei -- li -- gen Geist.
  %Şi a -- cum şi pu -- ru -- rea şi în ve -- cii ve -- ci -- lor. A -- min.
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
  
  Hei -- li -- ger Gott, __
  Hei -- li -- ger Star -- ker,
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
}

tenorWords = \lyricmode {
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 2.
  Jetzt und im -- mer -- dar und von E -- wig -- keit zu  E -- wig -- keit. A -- men.
 
}

bassWords = \lyricmode {
  A -- men.
  Hei -- li -- ger Gott,
  Hei -- li -- ger Star -- ker,
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
  
  Jetzt und im -- mer -- dar und in al -- le E -- wig -- keit.
  A -- men. Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser.
  
  Hei -- li -- ger Gott,
  Hei -- li -- ger Star -- ker,
  Hei -- li -- ger Un -- sterb -- li -- cher,
  er -- bar -- me Dich un -- ser. 
}

sopMusic = \relative c' {
 % Amin.
  f2^\mf a
  
  \repeat volta 3 {
    % Sfinte Dumnezeule
    a4(^\p g) f8([ e)] d([^\< e)] f4(\! g a2) 

    % Sfinte tare
    a4(^\accent g) c^\< b 
    \time 2/4 a\! a 

    \time 4/4
    % Sfinte făr' de moarte
    d4^\mf d d d c^\accent b^\> a g\! 

    % Miluieşte-ne pre noi.
    f^\p^\< g a(\! g) f8([^\> g e f])\! d4^\pp b'4\rest 
  }
  \break
  
  \mark "                        Ehre sei dem Vater"
  
  % Mărire Tatălui şi Fiului şi Sfântului Duh.
  d,4^\mf d d d g^\accent f g a^\< b g\! a h 
  c8([^\accent d] c4) b8([ a]) g4^\> 
  \time 2/4
  a2\! 

  % Şi acum şi pururea şi în vecii vecilor, amin.
  %d,4^\p d g^\accent f g^\accent a^\> a2
  %a4\! h^\< c h\! c8([ d]) c4^\> b8([ a])\! \breathe g4^\< a2\!
  \time 4/4
  b2\rest b2\rest b2\rest b2\rest b2\rest b2\rest b2\rest b2\rest
   
  % Sfinte făr' de moarte
  d4^\mf d d d c^\accent b^\> a g\!

  % Miluieşte-ne pe noi.
  f^\p^\< g\! a( g) f8([^\> g e f])\! 
  d4^\pp b'4\rest
  \bar "|." \break
  
  \mark "      'Stärker' "
  
  % Sfinte Dumnezeule
  a4(^\mf g) f8([ e)] d([ e)] 
  f4(^\< g a2)\! 
  
  % Sfinte tare
  f'4(^\f^\< d) e\! cis
  d2^\> d

  % Sfinte făr' de moarte
  d4\!^\mf d d d
  c^\accent b a g

  % Miluieşte-ne pe noi.
  f^\p^\< g\! a( g) f8([^\> g e f)]\! 
  d2^\pp^\fermata \bar "|."
}

altMusic = \relative c' {
  f2 f
  f4( e) d d d( e f2) f4( e) e g f f
  b4 b b b a g f e d e f( e) d( cis) d4 b'4\rest
  %d,4 d d d d d d d d d f e2 e4 e f2
  d,4 d d d g f g a g g f f a2 g8([ a]) g4 f2
  %d4 d g f e f f2 f4 f e e a a b8([ a]) g4 a2
  b2\rest b2\rest b2\rest b2\rest b2\rest b2\rest b2\rest b2\rest
  
  b4 b b b a g f e d e f( e) d( cis) d4 b'4\rest
  f4( e) d d d( e f2) a4( a) g g f2 f
  f4 f g g f g f e d e f( e) d( cis) d2
   
}

tenorMusic = \relative c {
  f2 f d2\rest
  f8([ e d e)] f4 c f2
  d2\rest c4 d8 e f4 g8([ a])
  b4 f b f8([ g]) a4 g f c
  d4 e f( g) a( a,) d4 d4\rest
  
  %d4 d d g f g a b g a h c8([ d] c4) b8([ a]) b4 c2
  d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest
  %d4 d b a b c c2 c4 h c h c c b8([ a]) g4 a2
  d4 d g a a2 a4 h c h c8([ d] c4) b8([ a]) g4 a a
  
  
  b4 f b f8([ g]) a4 g f c d4 e f( g) a( a,) d4 d4\rest
 
  d2\rest d2\rest %f8([ e d e)] 
  f4 c8 c f2
  d2\rest d2\rest a'4 a8 a b4 b 
  b4 a g g a g f c
  d4 e f( g) a( a,) d2
}


bassMusic = \relative c {
  % Amin.
  f2 f d2\rest
  f8([ e d e)] f4 c f2
  d2\rest c4 d8 e f4 g8([ a])
  b,4 b b8([ c]) d([ e]) f4 g f c
  d4 d d( c) a( a) d d4\rest
  
  %d4 d d d d d d d d d d c2 c4 c f2
  d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest d2\rest
  %d4 d c d e f f2 f4 f c c c c c8([ d]) g4 a2
  d4 d g f4 f2 f4 f e e a( a) b8([ a]) g4 a a
 
  b,4 b b8([ c]) d([ e]) f4 g  f c
  d4 d d( c) a( a) d d4\rest
  
  d2\rest d2\rest %f8([ e d e)] 
  f4 c8 c f2
  d2\rest d2\rest a'4 a8 a b4 b
  %b4 a g g a( g) f( c)
  d,4. f8 b4 d, c c c c
  d4 d d( c) a( a) d2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff = "staff" <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\addlyrics { \tenorWords }
      \new Voice { \global \voiceTwo \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
  %\layout { #(layout-set-staff-size 15) }
}  

midiOutput = \midi {
    \tempo 4 = 50
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}