\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 16))
  %markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.0\cm
  line-width = 19.2\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 3\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Heilig"
  subtitle = "5. Ton"
  composer = \markup \center-column { "Protos Varlaam" \small 
  "nach N. Moldoveanu" }
  meter = "Andante"
  tagline=""
}

global = {
  \key d \minor
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Hei -- lig, hei -- lig, hei -- lig der Herr Ze -- ba -- oth,
  er -- füllt sind Him -- mel und auch Er -- de 
  von Dei -- ner Herr -- lich -- keit.
  Ho -- san -- na, ho -- san -- na, ho -- san -- na,
  ho -- san -- na __ in der Hö -- he.
  Ge -- prie -- sen sei der da kommt, der da kommt, kommt __
  im Na -- men des Herrn. __
  Ho -- san -- na, ho -- san -- na, ho -- san -- na,
  ho -- san -- na __ in der Hö -- he.
}
menWords = \lyricmode {
  Hei -- lig, hei -- lig, hei -- lig der Herr Ze -- ba -- oth,
  er -- füllt sind Him -- mel und auch Er -- de 
  von Dei -- ner Herr -- lich -- keit.
  Ho -- san -- na, ho -- san -- na, ho -- san -- na,
  ho -- san -- na __ in der Hö -- he.
  Ge -- prie -- sen sei der da kommt, der da kommt, kommt __
  im Na -- men des Herrn. __
  Ho -- san -- na, ho -- san -- na, ho -- san -- na,
  ho -- san -- na in der Hö -- he.
}

sopMusic = \relative c' {
  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h'4^\f h^\fermata \bar"|"
  e4 e^\fermata 
  e4^\mf h4 
  c4 h8( a) g4^\< a4 
  h4.

  % Plin e cerul şi pământul de mărirea Ta
  e8\! e4^\f fis4 
  g4.( fis8 e8[ dis8 e8 fis8)] 
  e2 
  h4^\p h4 
  c8([ h8 a8 h8)] g4 g 
  g8([ fis8)] e4 h'4 h4 
  e,2 \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4^\p 
  g4 g2 \breathe fis4 
  a4 a2 \breathe g4^\mf 
  h4 h2 
  e4^\f fis4 
  g8([ a8] g4) fis4 e4 
  fis4( dis4) 
  e2 

  % Bine este cuvântat cel ce vine
  c4\rest e4^\p e h 
  c4( h8[ a8)] g4 a4 
  h2 a4 d4 
  d8([ c8 h8 c8]) h4(~ \tuplet 3/2 { h8[ a8 g8] } 

  % Întru numele Domnului.
  a4) a4 
  e'4( d8[ c8]) h4 a4 
  g8([ a fis g] e2) \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4 g4 g2  \breathe 
  fis4 a4 a2 \breathe 
  g4 h4 h2 e4 fis4 g8([ a8] g4) 
  fis4 e4 fis2( dis) e^\fermata
  \bar "|."
}

altoMusic = \relative c' {
  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h'4 h h h h4 h4 c4 h8( a) g4 fis g4.

  % Plin e cerul şi pământul de mărirea Ta
  g8 g4 h4
  e4.( dis8 h2)
  h2
  g4 g4
  a8([ g8 fis8 g8)] e4 e
  g8^\<([ fis8)] e4 fis4 fis4
  e2\! \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4
  g4 g2 \breathe fis4
  fis4 fis2 \breathe g4
  g4 g2
  c4 d4
  e2 dis4 e4
  dis4( h4) h2

  % Bine este cuvântat cel ce vine
  c4\rest h h h
  c4( h8[ a8)] g4 fis4
  g2 fis4 a4
  a2 g2(

  % Întru numele Domnului.
  a4) a4
  c4( h8[ a8]) g4 fis4
  g8([ a fis g] e2) \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4^\mf
  g4 g2 \breathe fis4^\p
  fis4 fis2 \breathe g4^\mf
  g4 g2
  c4 d4 e2
  dis4 e4
  dis2( h) h
}

tenorMusic = \relative c' {
  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h4 h g g g g a4 g8( fis) e4 d g4.

  % Plin e cerul şi pământul de mărirea Ta
  e8\rest e4\rest e8\rest
  h'8 h4. a8 g8([ fis8 g8 a8)]
  g2
  %h2
  e4 e4
  d2 e4 e
  g8([ fis8)] e4 dis4 dis4
  e2

  % Osana, osana, osana, osana întru cei de sus.
  e4\rest d4
  g4 g4 e4\rest d4
  d4 d4 e4\rest g4
  h4 g4
  c4 c4
  h8([ c8] h4) h4 c4
  h4( h8[ a8)] g2

  % Bine este cuvântat cel ce vine
  e4\rest e4 e8([ fis8)] g4
  a4( g8[ fis8)] e4 d4
  g2 d4 d4
  d2 e2(

  % Întru numele Domnului.
  a4) a4
  a2 e4 fis4
  g8([ a fis g] e2)

  % Osana, osana, osana, osana întru cei de sus.
  e2\rest g8[ g] g4 
  e2\rest a8[ a] a4 
  e2\rest g8[ g] g4
  c4 c4 c2 h4 c4
  h2( h4 a4) g2 %h2 
}

bassMusic = \relative c' {
  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h4 h e, e e e a g8( fis) e4 d g4. 

  % Plin e cerul şi pământul de mărirea Ta
  e8\rest e4\rest e8\rest
  e8 e4. fis8 g8([ fis8 e8 dis8)]
  e2
  e4 e4
  d2 e4 e
  g8([ fis8)] e4 h4 h4
  e2

  % Osana, osana, osana, osana întru cei de sus.
  e4\rest d4
  g4 g4 e4\rest d4
  d4 d4 e4\rest g4
  h4 g4
  c4 a4
  e2 fis4 g4
  h4( h,) e2

  % Bine este cuvântat cel ce vine
  e4\rest e4 e8([ fis8)] g4
  a4( g8[ fis8)] e4 d4
  g2 d4 d4
  d2 e2(

  % Întru numele Domnului.
  a4) a4
  a2 e4 fis4
  g8([ a fis g] e2)

  % Osana, osana, osana, osana întru cei de sus.
  e2\rest g8[ g] g4 
  e2\rest d8[ d] d4 
  e2\rest g8[ g] g4
  c4 c4 c2 h4 c4
  h2( h,) e
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \transpose e d \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \transpose e d \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \transpose e d \tenorMusic }
      \addlyrics { \menWords }
      \new Voice { \voiceTwo \global \transpose e d \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \altoMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \bassMusic }
  \midi { \midiOutput }
}
