\version "2.24.0"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Rugăciune"
  subtitle = "Rugămu-ne-ndurărilor"
  composer =  \markup \center-column { "T: Mihai Eminescu (1850 – 1889)"
  	  	"M: Teodor Teodorescu-Iaşi (1876 - 1920)" }
  meter = "Andante-religioso"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key c \major
  \time 4/4
  \partial 8
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}

womenWords = \lyrics {
  Ru -- gă -- mu -- ne-n -- du -- ră -- ri -- lor
  Lu -- cea -- fă -- ru -- lui mă -- ri -- lor!
  Din va -- lul ce ne bân -- tu -- ie,
  î -- nal -- ţă -- ne, __ ne __ mân -- tu -- ie!
  Pri -- vi -- rea-ţi a -- do -- ra -- tă
  a -- su -- pră -- ne co -- boa -- ră,
  O! Mai -- că Prea -- cu -- ra -- tă
  şi pu -- ru -- rea __ Fe -- cioa -- ră,
  Fe -- cioa -- ră Ma -- ri -- e.
}  

stanzaTwo = \lyrics {
  Cră -- ia -- să a -- le -- gân -- du -- te 
  în -- ge -- nun -- chem, ru -- gân -- du -- te,
  as -- cu -- lt-a noa -- stre plân -- \skip 1 geri, 
  Re -- gi -- nă pe -- ste __ în -- \skip 1 geri. 
  Din ne -- guri Te a -- ra -- tă, 
  Lu -- mi -- nă dul -- ce, cla -- ră, 
  O! Mai -- că Prea -- cu -- ra -- tă
  şi pu -- ru -- rea __ Fe -- cioa -- ră,
  Fe -- cioa -- ră Ma -- ri -- e.
}	

menWords = \womenWords

sopMusic = \relative c'' {
  g8^\p
  e'4. d8 c4. b8 d^\>([ c]) b([ a]) g4\! r8 
  g a4 b^\< c d\! e4.^\> d16([ c]) d4\!\fermata r8
  d8^\f g4. g8 f4 f f8([ e]) ^\markup"dim." d([ cis]) d4 dis e4. ^\markup"rall." d8 
  d^\<([ c\!]) b^\>([ c\!])
  e4^\p d c^\fermata r8
  g^\pp c4. b16([ a]) b4 b e4.( d8) c4 r8
  g^\p e'4. d16([ c]) d4 d g4.( f8) e4 r8
  e^\mf d4. d8 a'4 a g4.( f8^\>) e4 dis\!
  e4.^\p ^\markup "rall." d8 d([ c]) b([ c])
  e4( d) c\fermata
  c c2^\<^\pp c4.\!^\> d8\!
  e2^\<^\ppp e4\fermata^\> r4\!
  \bar "|."
}

altMusic = \relative c'' {
  g8
  c4. b8 c4. g8 g4 fis g r r r8
  g g g b b c4 g b4 r8
  b c4. c8 c([ b]) d([ c]) bes4 a d c c4. b8 b4 g
  c b g r8
  g a4 d, gis gis a( gis) a r8
  g c4 g b b
  c4( b) c r8
  cis d4. d8 d4 dis e( d) c c c4. b8 b([ c]) g[( c])
  c4.( b8) g4 g a2 a4. <b aes>8 <c g>2 <c g>4 r  	
}

tenorMusic = \relative c' {
  g8
  g4. g8 g([ a g]) f e4 dis e r r r8
  g g g g g g4. f16([ e]) g4 r8
  g g4. bes8 a([ gis]) bes([ a]) g4 f8([ g]) a4 a g4. g8 g4 f8([ e])
  g([ fis]) f4 e r8
  e e4. d16([ c]) e4 e e2 e4 r8
  g g4. f16([ e]) f4 f
  g2 g4 r8
  a a4. a8 c4 c c( b) c a g4. g8 g4 f8([ e])
  g([ fis] f4) e e f2 f4. f8 e2 e4 r  	
}
	
bassMusic = \relative c {
  g'8
  c,([ e g]) f e([ f e]) d c4 c c r8
  g' fis4 f e d c4. c8 g4 r8
  g' e4. e8 f4 f cis d8([ e]) f4 fis g4. f8 f([ e]) d([ c])
  g4 g c r8
  e a,4 a e'4. d8 c4( b) a r8
  g c4 c g4. f'8 e4( d) c r8
  f f4. f8 f4 fis g4.( gis8) a4 fis 
  g4. f8 f([ e]) d([ c])
  g2 c4 c4 c2 c4. c8 c2 c4 r
}

myScore = \new Score <<
  \new ChoirStaff <<
     \new Staff <<
      \set Staff.instrumentName = #"T I."  
      \new Voice { \global \sopMusic }
      \addlyrics { \womenWords }
      \addlyrics { \stanzaTwo }
     >>

     \new Staff <<
      \set Staff.instrumentName = #"T II." 
      \new Voice { \global \altMusic }
      \addlyrics { \womenWords }
      \addlyrics { \stanzaTwo }
     >>
     
      \new Staff <<
       \clef bass 
       \set Staff.instrumentName = #"Bar."
       \new Voice { \global \tenorMusic }
       \addlyrics { \womenWords }
       \addlyrics { \stanzaTwo }
     >>
     
     \new Staff <<
      \clef bass
      \set Staff.instrumentName = #"Bas."
      \new Voice { \global \bassMusic }
      \addlyrics { \womenWords }
      \addlyrics { \stanzaTwo }
     >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
