\version "2.24.0"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 1\mm
  bottom-margin = 1\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Rugăciune"
  subtitle = "Rugămu-ne-ndurărilor"
  subsubtitle = "(variantă)"
  composer =  \markup \center-column { "T: Mihai Eminescu (1850 – 1889)"
  	  	"M: Teodor Teodorescu-Iaşi (1876 - 1920)"
  		\small "Armonizare: prof. T. Sechei" }
  meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key d \major
  \time 3/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
}


womenWords = \lyrics {
  Ru -- gă -- mu -- ne-n -- du -- ră -- ri -- lor
  Lu -- cea -- fă -- ru -- lui mă -- ri -- lor!
  Din va -- lul ce ne bân -- tu -- ie,
  î -- nal -- ţă -- ne, ne mân -- tu -- ie!
  Pri -- vi -- rea-ţi a -- do -- ra -- tă
  a -- su -- pra -- ne-o co -- boa -- ră,
  o, Mai -- că Prea -- cu -- ra -- tă
  şi pu -- ru -- rea Fe -- cioa -- ră
  Ma -- ri -- e, Ma -- ri -- e.
}  

stanzaTwo = \lyrics {
  Cră -- ia -- să a -- le -- gân -- du -- te 
  în -- ge -- nun -- chem, ru -- gân -- du -- te,
  as -- cu -- lt-a noa -- stre plân -- \skip1 geri, 
  Re -- gi -- nă pe -- ste în -- \skip1 geri. 
  Din ne -- guri Te __ a -- ra -- tă, 
  Lu -- mi -- nă dul -- ce, cla -- ră, 
  o, Mai -- că Prea -- cu -- ra -- tă
  şi pu -- ru -- rea Fe -- cioa -- ră
  Ma -- ri -- e, Ma -- ri -- e.
}	

menWords = \womenWords

sopMusic = \relative c'' {
  a,4
  d2 d4 d2 e4 fis2 fis4 fis2 fis4
  e2 a,4 e'2 d4 e2 fis4 d2 a4 fis'2 e4
  fis2 g4 a2 g4 fis2 d'4 cis2 b4 a2 fis4 
  b2 a4 fis2 a4 a( fis) d
  b( d) fis a2. a2 b4 b( g) e
  cis( e) g b2. b2 cis4 cis( a) fis
  d( fis) a
  d2. d2 a4 fis'2 e4 d2 a4 cis2.
  b2 a4 e'2. a,2 a4
  cis( b a g e d cis2 d4) d2 
  
  \fermata  \bar "|."
}

altMusic = \relative c'' {
  a,4
  a2 b4 a2 cis4 d2 d4 d2 d4 
  cis2 a4 cis2 d4 cis2 d4 d2 a4
  d2 cis4 d2 e4 fis2 cis4 d2 d4 
  e2 d4 e2 d4 d2 cis4 d2 fis4
  fis( d) d b( b) d fis2. fis2 g4
  g( e) cis cis( cis) e d2. d2 e4
  fis2 d4 d2 fis4 fis2. fis2 fis4
  a2 g4 fis2 fis4 e2. d2 fis4 g2. fis2 a4 
  a( g fis e cis d a2.) a2
  
}

tenorMusic = \relative c' {
  a4
  fis2 g4 fis2 a4 a2 a4 a2 a4
  a2 a4 a2 a4 a2 a4 fis2 a4
  a2 a4 a2 a4 a2( a4) a2 fis4
  a2 fis4 a2 a4 g2( g4) a2 a4 
  a2 fis4 g2 a4 a2. a2 g4 
  g2 g4 g2 a4 fis2. g2 a4
  a2 a4 a2 a4 a2. a2 a4 a2 a4 a2 a4
  g2. fis2 a4 a2. a2 a4 a2.( a g) fis2
	
}
	
bassMusic = \relative c {
  a4
  d2 d4 d2 a4 d2 d4 d2 d4
  e2 fis4 g2 fis4 g2 a4 d,2 a4 d2 a4
  d2 cis4 d2( e4) d2 b4 a2 b4 cis2 d4 
  g,2( a4) d2 d4 d2 d4
  d2 d4 d2. d2 g,4 g2 a4 a2 a4
  b2. b2 a4 a2 a4 d2 d4
  d2. d2 d4 d2 e4 fis2 a4 a,2. 
  b2 d4 cis2. d2 a4 a2.( a a) d2
}

myScore = \new Score <<
  \new ChoirStaff <<
     \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
      \addlyrics { \stanzaTwo }
     >>

     \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
     >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
