\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  system-system-spacing = #'((basic-distance . 15))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  %ragged-right = ##t
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Rugăciune"
  %subtitle = "from Stabat Mater"
  %subsubtitle = "Op. 40"
  %subsubtitle = "Op. 21"
  %poet = "după Andra Gogan"
  composer = \markup \center-column { "Pr. Constantin Drăgușin" \small 
  "(1931 – 2014)" }
  %arranger = "Satz J. Knuth"
  meter = "Andante sostenuto"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOn
  %\cadenzaOn
  \time 4/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  %\set stanza = "1. "
  Doam -- ne, pe Ti -- ne noi Te ru -- găm,
  Ţi -- e îţi î -- năl -- ţăm ru -- gă -- ciu -- ne în im -- ne
  și-n psalmi Te cân -- tăm și Te mă -- rim.
  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a, a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a, __ a -- li -- lu -- i -- a.
}
 
bassWords = \lyricmode {
  Doam -- ne, pe Ti -- ne noi Te ru -- găm,
  Ţi -- e îţi î -- năl -- ţăm ru -- gă -- ciu -- ne în im -- ne
  și-n psalmi Te cân -- tăm și Te mă -- rim.
  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a, a -- li -- lu -- i -- a, __
  a -- li -- lu -- i -- a.
}
  
sopMusic = \relative c'' {
  a2^\p( g4 a) f2.^\< g4 a4.\!( b8 a4 g8[ a])
  \time 2/4 f4 f \time 4/4 f2 a g2. r4
  f4^\p^\< f8 f g4 a b2\! f4 g a2^\> a4. a8 c2\! g4 b
  a4.^\>( g8) f4 e8\!([ f]) g4. g8 f4 e f2. r4
  a2^\p( g4) a4 f2^\< g a2.\! r4 c2( b4) a b2^\> g f\!
  c4 c a'4.( g8 f4) e f1( f f2) 
  f4^\pp f f2 f f2. r4  
  \bar"|."
}

altMusic = \relative c' {
  f1 d2. e4 f1 c4 d c2 f e2. r4
  d4 d8 d e4 f f2 f4 f f2 f4. f8 e2 e4 e
  f4.( e8) f4 e8([ f]) e4. e8 c4 c c2. r4
  f2. f4 d2 e f2. r4 e( f g) f e2 e c 
  c4 c f4.( e8 c4) c c2 c4 c d d c( es d c) 
  c c d2 des c2. r4  
}

tenorMusic = \relative c' {
  c2( b4 c) b2. c4 c4.( d8 c4 b8[ c]) a4 b a2 c c2.r4
  a4 a8 a c4 c d2 d4 des c2 c4. c8 c2 c4 c
  c2 c4 c c4. b8 a4 b a2. r4
  c2( b4) c a2 c c2. r4 c2. c4 c2 c4( b) a2
  c4 c c2. b4 a2 a4 a b b a( c b a)
  a a b2 b a2. r4  
}

bassMusic = \relative c {
  f1 f2. c4 f1 f4 f f2 f c2. r4
  d4 d8 d c4 f <b b,>2 <b b,>4 <b b,> f2 f4. f8
  <<
   {
    \voiceOne
     g4( b) b g }
   \new Voice {
    \voiceTwo
     c,2 c4 c }
  >>
  \oneVoice
  f4.( g8) a4 b8([ a]) g4 c, c c f2. r4 r1
  d4 d c c f2. r4 r1
  c4 c c c f2 c'4 c f,4.( g8 a4) b8([ g]) f1( f f2)
  f4 f <f b,>2 <f b,> <f f,>2. r4  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \global \sopMusic }
     \addlyrics { \bassWords }
    >>
      
    \new Staff <<
     \new Voice { \global \altMusic }
     \addlyrics { \sopWords }
    >>  
    
    \new Staff <<
     \clef "G_8"
     \new Voice { \global \tenorMusic }
     \addlyrics { \sopWords }
    >> 
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
      %\new Lyrics \lyricsto "split" { a -- şa, a -- şa şi pre pă -- mânt. }
     
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 50
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

