\version "2.24.0"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Ridica-voi ochii mei la ceruri"
  subtitle = "(variantă)"
  composer =  \markup \center-column { "Armonizare: Gh. Dobreanu (1911 – 2001)"}
  meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key g \major
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}

womenWords = \lyrics {
  Ri -- di -- ca -- voi o -- chii mei la ce -- ruri,
  De un -- de va ve -- ni a -- ju -- to -- rul meu.
  A -- ju -- torul __ meu de __ la Dumne -- zeu,
  Cel ce a fă -- cut ce -- rul şi pă -- mân -- tul.
}  

stanzaTwo = \lyrics {
  Că -- tre Dom -- nul pa -- şii mei voi du -- ce
  Şi Le -- gea Lui va fi în -- drep -- ta -- rea mea
  Doam -- ne, Doam -- ne, Doam -- ne, Doam -- ne,
  gla -- sul meu a -- uzi, când mă rog eu Ţi -- e! 
}	

stanzaThree = \lyrics {
  În -- tru Ti -- ne eu mi-am pus nă -- dej -- dea,
  Să nu mă de -- păr -- tezi de la fa -- ţa Ta!
  A -- li -- lu -- ia, a -- li -- lu -- ia,
  a -- li -- lu -- i -- a, sla -- vă Ţi -- e, Doam -- ne! 
}	

menWords = \womenWords

sopMusic = \relative c'' {
  e,8^\p fis
  g2 g fis4 g b a g2( fis) e2 b'4\rest
  b c2 b4 e,8 fis g2. fis8 g b4( a) g( fis) e2. b'4\rest
  \repeat volta 2 {
    g4 d g( a) b2. g8( fis) e4 e'( d c) b2. b4\rest
    c b a b8( a) g2. fis8 g b4 a g( fis) e2. b'4\rest
  }
}

altMusic = \relative c'' {
  e,8 dis
  e2 e dis4 e g fis e2( dis) e2 b'4\rest
  e, fis2 g4 e8 dis e2. dis8 e g4( fis) e( dis) b2. b'4\rest
  \repeat volta 2 {
    g4 d e( fis) g2. g8( fis) e4 g2( fis4) d2. b'4\rest
    fis g fis8([ e]) e8( dis) e2. dis8 e g4 fis e( dis) b2. b'4\rest
  }
}

tenorMusic = \relative c' {
  e,8 b'
  b2 b b4 b d c b2( a) g2 d4\rest
  g a2 g4 g8 a b2. b8 b d4( c) b( a) g2. d4\rest
  \repeat volta 2 {
    g4 d g d' d2. g,8( fis) e4 c'( b a) g2. d4\rest
    a' b c b b2. b8 b d4 c b( a) <b g>2. d,4\rest
  }
}

bassMusic = \relative c {
  e8 b
  e2 e2 b4 e g a b2( b,) e2 d4\rest
  e4 d2 d4 e8 b e2. b8 e g4( a) b( b,) e2. d4\rest
  \repeat volta 2 {
    g4 d b( d) g2. g8( fis) e4 c( d d) g,2. d'4\rest
    d g a b e,2. b8 e g4 a b( b,) e2. d4\rest
  }
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
      \addlyrics { \stanzaTwo }
      \addlyrics { \stanzaThree }
    >>

    \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \layout { }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
