\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 25))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Christ ist auferstanden"
  subtitle = "Oster - Troparion"
  subsubtitle = "5. Ton"
  composer = "gr.-russ. Choral"
  %arranger = "G. Musicescu (1847 - 1903)"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  %\autoBeamOff
  %\cadenzaOn
  \time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Christ ist er -- stan -- den von den To -- ten,
  hat zer -- tre -- ten im Tod den Tod
  und de -- nen in den Grä -- bern
  das Le -- ben ge -- schenkt.
}

menWords = \womenWords


sopMusic = \relative c' {
  f4 f8 f f f g a b4 b b4\rest
  a8 b c4 c8 c b4 a \time 3/4 b4
  b4\rest a4 a a a8 a a4 a b a g g f^\fermata b\rest
  
  \bar "|."
}

altMusic = \relative c' {
  f4 f8 f f f f f f4 f b4\rest
  f8 f f4 f8 f f4 f  f b4\rest
  f4 f f f8 f f4 f f f e e f b\rest
}

tenorMusic = \relative c' {
  a4 a8 a a a b c d4 d d,4\rest
  c'8 d es4 es8 es d4 c d d,4\rest
  c'4 c c c8 c c4 c d c b b a d,\rest
  
}

bassMusic = \relative c {
  f4 f8 f f f d c b4 b d4\rest
  f8 f f4 f8 f f4 f b, d4\rest
  f4 f f f8 f f4 f b, c c c f d\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     \addlyrics { \womenWords }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \new Voice { \voiceTwo \global \altMusic }
     %\addlyrics { \womenWords }
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 55
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}