\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 2\mm
  bottom-margin = 1\mm
  ragged-last-bottom=##f
  system-count = #12
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Heruvic"
  subtitle = "Nr. 1, glas 8 (3 voci egale)"
  composer = "Armonizare: N. Lungu" 
  meter = "Adagio"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOff
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Noi __ ca -- re, 
  ca -- re pe he -- ru -- vimi, __ pe he -- ru -- vimi,
  cu __ tai -- nă, cu tai -- nă în -- chi -- pu -- im,
  cu tai -- nă în -- chi -- pu -- im, __
  în -- chi -- pu -- im.
  
  Şi fă -- că -- toa -- rei de vi -- a -- ţă Tre -- imi, __
  fă -- că -- toa -- rei de vi -- a -- ţă Tre -- imi,
  în -- tre -- it __ sfân -- tă cân -- ta -- re a -- du -- cem,
  cân -- ta -- re,  cân -- ta -- re a -- du -- cem,
  a -- du -- cem.
  
  Toa -- tă gri -- ja lu -- meas -- că, __
  gri -- ja, gri -- ja __ cea lu -- meas -- că,
  să __ o __ le -- pă -- dăm, să o __ le -- pă -- dăm,
  s-o le -- pă -- dăm.
}

menWords = \lyricmode {
  A -- min.
  Noi __ ca -- re, 
  ca -- re pe he -- ru -- vimi, pe he -- ru -- vimi,
  cu __ tai -- nă, cu tai -- nă în -- chi -- pu -- im,
  cu tai -- nă în -- chi -- pu -- im,
  în -- chi -- pu -- im.

  Şi __ fă -- că -- toa -- rei de vi -- a -- ţă Tre -- imi,
  fă -- că -- toa -- rei de vi -- a -- ţă Tre -- imi,
  cân -- ta -- re a -- du -- cem,
  cân -- ta -- re, cân -- ta -- re, 
  cân -- ta -- re a -- du -- cem,
  a -- du -- cem.
  
  Toa -- tă gri -- ja lu -- meas -- că, __
  gri -- ja, gri -- ja cea lu -- meas -- că,
  să o le -- pă -- dăm, să o le -- pă -- dăm,
  s-o le -- pă -- dăm.
}


sopMusic = \relative c'' {
  f,4^\p( e8[ f] g4 a) f2 \bar "||"
  f8([ g] f4) g4.( a8 g4 a) f2
  a4( g8[ a]) f4 f g( a)
  b( c) a8([ b] a4) \breathe
  g( a8[ b]) a4( g) f( e) f2 \fermata
  e4( f) g4.( a8) g4 f
  e4.( f8 e4 d8[ e])
  c4 c d2 e8[( f] e4)
  f4. g8 a4( g8[ a]) 
  f4 f g( a) b( c) 
  a8([ b] a4) \breathe
  g( a8[ b]) a4( g)
  f( e) f2 \fermata
  h2\rest h4\rest
  f4 a b c4.( d8) c4 b8 b
  a4.( b8) a4 g8([ a])
  f4( g) a b c( b a8[ b c d])
  c2 d4 d e8([ f e d] e4. f8)
  e4 d8([ e]) c2
  c4^\< d es\!( d^\>) c4( b8[ c\!])
  a4. g8 a8([ b a g]) a4 b
  c2 c4.^\< c8 d2( 
  \tuplet 3/2 { es8[ d c\!~] } c4
  \tuplet 3/2 { d8[ c b~] } b4)
  a4. g8^\> a2 g4 g\!
  f2( e) f( f f) \breathe
  b8([ c b]) a 
  g8^\mf([ f]) g a b4( c)
  b4( c) \breathe d4.( es8) c2 
  \mark \markup { \musicglyph "scripts.coda" }
  f2^\f e4( d8[ e]) c4^\< d
  e4.\!( f8 e4^\> d8[ e\!])
  c2 b4.( c8 b4 c)
  a4.( b8 a4 b)
  g4.^\>( a8 g4 a) f2\!
  g2 g4^\p a8([ b]) a4( g)
  f( e) f2( f^\markup { "D'al  " \musicglyph "scripts.coda" "al fine" } 
  f) ^\fermata
  \bar "|."
}

altMusic = \relative c' {
  f4( e8[ f] e2) f2 f8([ g] f4) g4.( a8 g4 a) f2
  f4( e8[ f]) f4 f e( f) g( a) f8([ g] f4)
  e4( f8[ g]) f4( e) f( c) f2
  c4( d) e4.( f8) e4 f e4.( f8 e4 d8[ e])
  c4 c d2 e8[( f] e4) f4. e8 f4( e8[ f]) f4 f
  e( f) g( a) f8([ g] f4) e4( f8[ g]) f4( e) f( c) f2
  h2\rest h4\rest f f g a4.( b8) a4 g8 g f4.( g8) f4 e f( g)
  f4 g a( g f8[ g a b]) a2 b4 g c2( c) c4 g c2
  a4 b c( b) a( g8[ a]) f4. e8 f([ g f e]) f4 g a2 a4. a8
  b2( \tuplet 3/2 { c8[ b a~] } a4 \tuplet 3/2 { b8[ a g~] } g4)
  f4. e8 f2 e4 e f2( e) f4 d c( d) f2
  b8([ c b]) a 
  g8([ f]) g a b4( a) b( c) b2 a a4( c) c2 c4 c c2( g) c
  g4.( a8 g4 a) f4.( g8 f4 g) e4.( f8 e4 f) d2 e
  e4 f8([ g]) f4( e) f( c) f d c d f2
  
  
}

bassMusic = \relative c {
  f4( e8[ f] c2) f
  f8[( g] f4) g4.( a8 g4 a) f2
  f4( e8[ f]) f4 f c2
  c f c c c f
  c4( d) c2 c4 d c2( c) 
  c4 c d2 c
  f4. c8 f2 f4 f c2 c f c c
  c f
  f2( f) f4 f f2 f4 c8 c
  f4.( g8) f4 c f2 f4 f f2( f)
  f b4 g c2( c)
  c4 g c,2 r r r r4 r8
  c f([ g f c]) f4 f
  f2 f4. f8 b2 f4. f8 
  \tuplet 3/2 { b8([ a g~] } g4)
  f4. c8 f2 c4 c
  c2( c) f4 \breathe d c( b) f'2
  b8([ c b]) a g([ f]) g a b4( f)
  b4( a) b2 f f4( a) g2
  c4 c c2( g)
  c2 r r r r
  c,4 c c2 d
  c2 c4 c c2 c f4 \breathe
  d c b <f f'>2  	
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global\voiceOne \sopMusic }
      \new Voice { \global\voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 40
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
