\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  system-system-spacing = #'((basic-distance . 15))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  %ragged-right = ##t
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Aliluia"
  %subtitle = "from Stabat Mater"
  %subsubtitle = "Op. 40"
  %subsubtitle = "Op. 21"
  poet = "după Andra Gogan"
  composer = "Leonard Cohen" 
  %arranger = "Satz J. Knuth"
  meter = "Moderato"
  tagline=""
}

global = {
  \key c \major
  \autoBeamOn
  %\cadenzaOn
  \time 12/8
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1. "
  Poţi să-n -- cerci să prinzi lu -- na că -- zu -- tă în puț
  sau să dai u -- nui om ne -- că -- jit un bă -- nuț 
  ori -- ci -- ne poa -- te vi -- sa, poa -- te să spe -- re; __
  da -- că-n su -- fle -- tul tău stă de ve -- ghe Ii -- sus
  nu-i ni -- mic mult prea greu și nici ce -- rul prea sus, 
  și-a -- uzi în -- ge -- rii cum cân -- tă: A -- li -- lu -- ia!
  A -- li -- lu -- ia, a -- li -- lu -- ia,
  A -- li -- lu -- ia, a -- li -- lu -- ia.
  A -- li -- lu -- ia, __
  A -- li -- lu -- ia, __ a -- li -- lu -- ia,
  A -- li -- lu -- ia, a -- li -- lu -- ia.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2. "
  Pen -- tru da -- rul di -- vin de-a fi ce -- ea ce ești
  o po -- run -- că ai doar de ur -- mat: Să iu -- bești! 
  duș -- "man și" pri -- e -- ten cu-a -- ce -- eași __ \skip 1 mă -- su -- ră. __
  Doar a -- șa-ți va zâm -- bi ne-n -- ce -- tat Dum -- ne -- zeu
  și-ai să poți fi în soa -- re sau ploa -- ie me -- reu 
  și-a -- uzi în -- ge -- rii cum cân -- tă: A -- li -- lu -- ia!
  
}
 
menWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  Uh __ Ah __ 
}
  
sopMusic = \relative c' {
  e8 f g g g g8. g16 g8 a a a8 a h8\rest 
  e,16 f g8 g g g8. g16 g8 a a a8 a h8\rest 
  g8 a4 a8 a a a8 g4. g8 g f e16([ f]) g4.( g g4) h4\rest 
  e,16 f g8 g g g4 g16 g a8 a a h4 
  h16 h c8 c c c4 c16 c c8 c c d4
  c16 c d4 d8 d4 d8 e4 e8 e4 
  
  d8 d( c8) c( c4.) h4.\rest
  e,4 g8 a4. a( a) a4 
  g8 e4. e( e) e4 
  g8 a4. a( a) a4 
  g8 e4.( e8 f e d4. d8 c h) c2.  h'4.\rest
  \bar ":|."
  e,4^\markup { \bold "Fine" }
  g8 a4. a( a) a4 h8 c4. c( c)
  c4 d8 e4.( e8[ f e] d4. d8[ c h]) <c g>4.
  
  \bar"|."
 
}

altMusic = \relative c' {
  e8 e e e e e8. e16 e8 f f f f h8\rest 
  e,16 e e8 e e e8. e16 e8 f f f f h8\rest 
  e,8 f4 f8 f f f e4. e8 e d c16([ d]) e4.( e e4) h'4\rest
  e,16 e e8 e e e4 e16 e f8 f f g4 
  g16 g a8 a a a4 a16 a a8 a a h4
  a16 a h4 h8 h4 h8 c4 c8 c4 h8
  h( a) a( a4.) h4\rest \skip 8
  e,4 e8 f4. f( f)
  f4 e8 c4. c( c)
  e4 e8 f4. f( f)
  f4 e8 c4.( c d d) c2. s4.
  e4 e8 f4. f( f) f4 g8 a4. a( a) 
  a4 h8 c4.( c8[ d c] h4. h8[ a g]) e4.
  
}

tenorMusic = \relative c {
  e8
  c'4 c8 c4 c8 c c c( c4) 
  e,8 c'4 c8 c c c c4 c8 c4 c8 
  c4 c8( c) c c c4 c8 c4 b8
  g4 g8( g4. g) d4\rest
  g8 g4 g8 g d\rest g c4 c8 
  d d\rest d f, f f( f4)
  f8 f f g( g4) f8 g g4 g g8 
  g4 g8 g4 g8 g( f) f( f4.) d\rest
  g4 c8 c4( h8) a4( h8 c4.)
  c4 c8 c4( d8) e4( d8 c4.)
  c4 c8 f4( e8) c4( h8 a4.)
  a4 g8 g4.( g8 a g f4. f8 e d) c2.  
}

bassMusic = \relative c {
  e8 d c c c c8. c16 c8 c c c c r
  e16 d c8 c c c8. c16 c8 c c c c r4
  c2.( c c4.) g8( a[ h] c c4) d4\rest
  e16 e c8 c c c4 c16 c c8 c c h4
  h16 h a8 a a a4 a16 a a8 a a g4
  g16 g g4 g8 g4 g8 g4 g8
  
  g4 g8 g( a) a( a4.) d\rest
  e4 e8 c4( h8) a4( h8 c4.) 
  c4 c8 e4( f8) g4( f8 e4.)
  %e4 e8 f,4( g8) a4( h8 c4.)
  e4 e8 c4( h8) a4( h8 c4.) 
  c4 c8 c4.( g a h) c2. d4.\rest
  %e4 e8 d4. d( d) d4 d8 c4. c( c)
  %c4 h8 a2.( g) c4.
  e8([ d]) c d([ c h]) a([ h c d e f])
  f([ e]) g f([ e d]) %c([ h a g a h]) c4 h8 a2.( h) c4.
  c([ d e] f4.)
  f4 g8 g2.( g) <g c,>4.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
    >>
    \new Staff <<
      \clef bass
      %\new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 50
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

