\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Ich bin die Auferstehung"
  subtitle = " "
  %subsubtitle = "glasurile 8, 1"
  composer =  \markup \center-column { "Ionel Gh. Brătianu"
   \small "(1885 - 1921)" }
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key es \major
  %\autoBeamOff
  %\time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Ich bin die Auf -- er -- ste -- hung und das Le -- ben;
  wer an Mich glaubt, wird e -- wig __ le -- ben,
  kommt auch der Tod, kommt auch der Tod,
  wer an Mich glaubt, wird e -- wig le -- ben.
 
  Wahr -- lich, Je -- sus  Chris -- tus,
  Du bist der Herr,
  der Du __ kamst in die -- se Welt!
}

menWords = \womenWords

sopMusic = \relative c'' {
  b4^\p b8 b c4 b g2^\> es f4.^\< f8 g4( as)\! b2. b4\rest
  b2 c4 b g2 es f as4( d,) es2 es4 b'4\rest
  \repeat volta 2 {
    as2^\p as4 g f2. b4\rest b4.(^\< c8) b4 as\! g2. b4\rest
    as2^\< c4 c b2 es\! d2^\f c b2 b4 b4\rest
  }
  b4. b8 c4 b g2^\< es f g4. as8\! b2. b4\rest
  b2 es4( d) c2.^\< f4 es2\! d es1 ^\fermata
  \bar "|."
}

altMusic = \relative c'' {
  g4 g8 g as4 g es2 es d4. d8 es4( f) g2. b4\rest
  g2 as4 g es2 es f f4( f) es2 es4 b'4\rest
   f2 f4 es d2. b'4\rest g4.( as8) g4 f es2. b'4\rest
   f2 f4 f f2 f b a b2 b4 b4\rest
  g4. g8 as4 g es2 es d es4. f8 g2. b4\rest
  g2 g4( g) as2. as4 g2 as g1
}

tenorMusic = \relative c {
  es4 es8 es es4 es es2 es b4. b8 es2 es2. d4\rest
  es2 es4 es es2 es f d4( b) es2 es4 d4\rest
   b2 d4 es b2. d4\rest es4.( es8) es4 d es2. d4\rest
   f2 es4 es d2 c f f b2 b4 d,4\rest
  es4. es8 es4 es es2 es b es4. es8 es2. d4\rest
  es2 es4( es) as2. f4 b2 b,2 es1
}

bassMusic = \relative c {
  es4 es8 es es4 es es2 es b4. b8 es2 es2. d4\rest
  es2 as,4 es' es2 es f b,4( b) es2 es4 d4\rest
   b2 d4 es b2. d4\rest es4.( es8) es4 b es2. d4\rest
   f2 es4 es d2 c f f b,2 b4 d4\rest
  es4. es8 es4 es es2 es b es4. es8 es2. d4\rest
  es2 es4( es) as2. f4 b,2 b2 \once \hide es1
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}