\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 1))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Dreifache Ektenie"
  subtitle = "8. Ton"
  composer = "nach N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key g \major
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison, e -- le -- ison.  
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison,
  Ky -- ri -- e e -- le -- ison.
}

menWords = \lyricmode {
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 
 
  Ky -- ri -- e e -- le -- ison.
  
}

sopMusic = \relative c' {
  \cadenzaOn

  g'4.^\markup{\hspace #-5.0 \bold \box 1}^\mf fis8 g4 a4 \bar "|"
  h4 g4 \bar "|"
  a4. g8 fis4 e8([ fis8)] \bar "|"
  e4 d4 \bar "|"
  g4. fis8 g4 a4 \bar "|"
  h2( \bar "|"
  a2) \bar "|"
  g2. h4\rest \bar "||" \break

  d4.^\markup{\hspace #-2.0 \bold \box 2} c8 h4 c4 \bar "|"
  d4 h4 \bar "|"
  c4. h8 a4 h4 \bar "|"
  c4 a4 \bar "|"
  d4. c8 h4 a8([ h8)] \bar "|"
  a4( g8[ a8] h8[ c8 a8 h8)] \bar "|"
  g2. h4\rest \bar "||" \break

  d4.^\markup{\hspace #-2.0 \bold \box 3} d8 d4 d4 \bar "|"
  c4( h4 c4) a4 \bar "|"
  e'4. e8 e4 e4 \bar "|"
  d4( c d) h4 \bar "|"
  a4. h8 c4 e4 \bar "|"
  d2( c2) \bar "|"
  h2. h4\rest \bar "||" \break

  d4.^\markup{\hspace #-2.0 \bold \box 4} d8 h4 c4 \bar "|"
  d4.( h8 e4) d4 \bar "|"
  c4. c8 a4 h4 \bar "|"
  c4.( a8 d4) c4 \bar "|"
  h4. h8 h4 h4 \bar "|"
  e2( d4 c4 \bar "|"
  h2 a2) \bar "|"
  h2. h4\rest \bar "||" \break
  
  h4(^\markup{\hspace #-2.0 \bold \box 5} a4.) a8 a[ h] \bar "|"
  c4 a \bar "|"
  h8[ h] h[ c] \bar "|"
  d4 h \bar "|"
  h4( a4.) a8 a[ h] \bar "|"
  c2 h4. h8\rest \bar "||" \break
  
  h8[^\markup{\hspace #-2.0 \bold \box 6} h] h[ c] \bar "|"
  d4( c8) h \bar "|"
  a8[ a] a[ h] \bar "|"
  c4( h8) a \bar "|"
  h[ h] h[ c] \bar "|"
  d4 e8[ e] \bar "|"
  d4( c) \bar "|" h4. h8\rest \bar "||" \break
  
  h8[^\markup{\hspace #-2.0 \bold \box 7} h] h[ h] \bar "|"
  h4 a2 \bar "|"
  c8[ c] c[ c] \bar "|"
  c4 h2 \bar "|"
  d4( c) h \bar "|"
  e( d) c \bar "|"
  h2( c8[ d] \bar "|"  c2.) \bar "|"
  h2 h4\rest \bar "||" \break
  
  d4.^\markup{\hspace #-2.0 \bold \box 8} d8 d4 d \bar "|"
  c8([ h a g]) fis2 \bar "|"
  e'4. e8 e4 e \bar "|"
  d8([ c h a]) g4( h) \bar "|"
  d4. h8 g4 h c8([ d e d] f[ e d c] \bar "|"
  h2 a) \bar "|"
  h2. h4\rest \bar "||" \break
  
  %b4.^\markup{\hspace #-2.0 \bold \box 9} c8 d4 d \bar "|"
  %d( e8[ d] c4) b \bar "|"
  %a4. b8 c4 c \bar "|"
  %e2( d4) c \bar "|"
  %b4. c8 d4 d \bar "|"
  %g2( e4 c  \bar "|" b2 a)  \bar "|" 
  %g2. b4\rest \bar "||" \break
  
  g4.^\markup{\hspace #-2.0 \bold \box 14} g8 a4 fis \bar "|"
  g2 g \bar "|"
  a4 h8([ c]) h4 a \bar "|"
  g2 g \bar "|"
  e4. e8 g4 fis8([ e]) \bar "|"
  d2 d4. h'8\rest \bar "||" \break
  
  e,4.^\markup{\hspace #-2.0 \bold \box 15} fis8 g4 a \bar "|"
  h4 h \bar "|"
  e4. fis8 g4 fis8([ e]) \bar "|"
  dis4 dis \bar "|"
  e( h c) a \bar "|" h( g a) fis \bar "|"
  h2.( a4) \bar "|" g2. h4\rest \bar "||" \break
  
  h4.^\markup{\hspace #-2.0 \bold \box 18} c8 d4 d \bar "|"
  e( d c) h \bar "|" a4. h8 c4 c \bar "|" 
  d( c h) a \bar "|" h d c h \bar "|"
  e2( d4 c \bar "|" h2 a) \bar "|" h2. h4\rest \bar "||" \break
  
  
  \bar "|."
}

altMusic = \relative c' {
  \cadenzaOn

  g'4. fis8 g4 a4
  h4 g4
  fis4. g8 fis4 e8([ fis8)]
  e4 d4
  g4. fis8 g4 a4
  g2(
  fis2)
  g2. h4\rest

  h4. a8 g4 a4
  h4 g4
  a4. g8 fis4 g4
  a4 fis4
  h4. a8 g4 fis4
  fis1
  g2. h4\rest

  h4. h8 h4 h4
  a4( g4 a4) fis4
  c'4. c8 c4 c4
  h4( a4 h4) g4
  fis4. g8 a4 c4
  h2( a2)
  g2. h4\rest

  h4. h8 g4 a4
  h4.( g8 c4) h4
  a4. a8 fis4 g4
  a4.( fis8 h4) a4
  g4. g8 g4 g4
  c2( h4 a4
  g2 fis2)
  g2. h4\rest
  
  g4( fis4.) fis8 fis[ g] a4 fis
  g8[ g] g[ a] h4 g
  g4( fis4.) fis8 fis[ g] a2 g4. h8\rest  
  
  g8[ g] g[ a] h4( a8) g fis[ fis] fis[ g]
  a4( g8) fis g[ g] g[ a] h4 c8[ c]
  h4( a) g4. h8\rest
  
  g8[ g] g[ g] g4 fis2 a8[ a] a[ a] a4 g2 
  h4( a) g c( h) a g2( a8[ h] a2.) g2 h4\rest
  
  h4. h8 h4 h a8([ g fis e]) d2
  c'4. c8 c4 c h8([ a g fis]) g2
  h4. g8 g4 g a8([ h c h] d[ c h a] g2 fis) g2. h4\rest
  
  %g4. a8 b4 b b( c8[ b] a4) g
  %fis4. g8 a4 a c2( b4) a
  %g4. a8 b4 b e2( c4 a g2 fis) g2. b4\rest
  
  g4. g8 a4 fis g2 g fis4 g8([ a]) g4 fis e2 e
  e4. e8 e4 d8([ c]) h2 h4. h'8\rest
  
  e,4. fis8 g4 fis g g h4. h8 e4 d8([ c]) h4 h
  h( g a) fis g( e fis) fis g2.( fis4) e2. h'4\rest
  
  g4. a8 h4 h c( h a) g fis4. g8 a4 a h( a g) fis
  g h a g c2( h4 a g2 fis) g2. h4\rest
  
}

tenorMusic = \relative c' {
  \cadenzaOn

  g4. fis8 g4 a4
  h4 g4
  d4. d8 d4 e8([ fis8)]
  e4 d4
  g4. d8 g4 a4
  g2(
  d2)
  g2. d4\rest

  g4. g8 g4 g4
  g4 g4
  d4. d8 d4 d4
  d4 d4
  g4. g8 g4 d4
  \skip 1 
  g2. d4\rest

  g4. g8 g4 g4
  d2. d4
  g4. g8 g4 g4
  g2. g4
  d4. d8 d4 d4
  \skip 1
  g2. d4\rest

  g4. g8 g4 g4
  g2. g4
  d4. d8 d4 d4
  d2. dis4
  e4. e8 e4 e4
  g2( fis4 e4 s1)
  g2. d4\rest
  
  g4( d4.) d8 d d d4 d
  g8[ g] g[ g] g4 g
  g4( d4.) d8 d[ d] d2 g4. d8\rest
  
  g8[ g] g[ g] g4( g8) g d[ d] d[ d]
  d4( d8) d g[ g] g[ g] g4 g8[ g]
  g4( fis) g4. d8\rest
  
  g8[ g] g[ g] g4 d2 d8[ d] d[ d] d4 g2
  g2 g4 g2 g4 g2.( d) g2 d4\rest
  
  g4. g8 g4 g d2 d g4. g8 g4 g d2 g
  g4. g8 g4 g s1( s) g2. d4\rest
  
  %g4. g8 g4 g g2. g4
  %d4. d8 d4 d d2. d4
  %d4. d8 d4 d g1( g2 a) b2. d,4\rest 
  
  g4. g8 a4 fis g2 g d4 d d d e2 e
  c4. c8 c4 c g2 g4. d'8\rest
  
  e4. fis8 g4 fis e e g4. a8 h4 g8([ fis]) fis4 fis
  d1\rest d\rest e8[ fis] g[ a] h4( h,) e2. d4\rest
  
  g4. g8 g4 g g2. g4 d4. d8 d4 d d2. d4
  g4 g g g g2.( fis4 g2 d) g2. d4\rest
  
}

bassMusic = \relative c' {
  \cadenzaOn

  g4. fis8 g4 a4
  h4 g4
  d4. d8 d4 e8([ fis8)]
  e4 d4
  g4. d8 g4 a4
  g2(
  d2)
  g2. d4\rest

  g4. g8 g4 g4
  g4 g4
  d4. d8 d4 d4
  d4 d4
  g4. g8 g4 d4
  d1
  g2. d4\rest

  g4. g8 g4 g4
  d2. d4
  c4. c8 c4 c4
  g'2. g4
  d4. d8 d4 d4
  d1
  g2. d4\rest

  g4. g8 g4 g4
  g2. g4
  d4. d8 d4 d4
  d2. dis4
  \accidentalStyle forget
  e4. e8 e4 e4
  c4( a4 h4 c4
  d1)
  g2. d4\rest
  
  g4( d4.) d8 d[ d] d4 d
  g8[ g] g[ g] g4 g
  g4( d4.) d8 d[ d] d2 g4. d8\rest
  
  g8[ g] g[ g] g4( g8) g d[ d] d[ d]
  d4( d8) d g[ g] g[ g] g4 c,8[ c]
  d4( d) g4. d8\rest
  
  g8[ g] g[ g] g4 d2 d8[ d] d[ d] d4 g2
  g2 g4 g2 g4 g2.( d) g2 d4\rest
  
  g4. g8 g4 g d2 d c4. c8 c4 c d2 g
  g4. g8 g4 g d1( d) g2. d4\rest
  
  %g4. g8 g4 g g2. g4
  %d4. d8 d4 d d2. d4
  %d4. d8 d4 d c2( e d1) d2. d4\rest 
  
  g4. g8 a4 fis g2 g d4 d d d e2 e
  c4. c8 c4 c g2 g4. d'8\rest
  
  e4. fis8 g4 fis e4 e e4. e8 e4 e h h
  d1\rest d\rest e8[ fis] g[ a] h4( h,) e2. d4\rest
  
  g4. g8 g4 g g2. g4 d4. d8 d4 d d2. d4
  g4 g g g c,2( d d d) g,2. d'4\rest
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
   \tempo 4 = 70
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
