\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 1))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Dreifache Ektenie"
  subtitle = "8. Ton"
  composer = "nach N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key g \major
  \time 4/4
  \autoBeamOn
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- bar -- me Dich.
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich,
  Herr, er -- bar -- me Dich,
  Herr, er -- bar -- me Dich.
  Herr, er -- bar -- me Dich,
  Herr, er -- bar -- me Dich,
  Herr, er -- bar -- me Dich.
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- bar -- me Dich.
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich, er -- bar -- me Dich.  
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- barm', er -- bar -- me Dich. 
  Herr, er -- bar -- me Dich,
  Herr, er -- bar -- me Dich,
  Herr, er -- bar -- me Dich.
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich.
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- barm',  er -- bar -- me Dich.
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,
  Herr, er -- barm' Dich,  er -- bar -- me Dich.
}

menWords = \lyricmode {
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 \skip 1
  \skip 1 \skip 1  \skip 1 \skip 1 \skip 1  \skip 1 
 
  Ky -- ri -- e e -- le -- ison.
  
}

sopMusic = \relative c' {
  \partial 2
  g'4^\markup{\hspace #-5.0 \bold \box 1}^\mf g8( a) 
  h4 g4 a4 g8( fis8) e4 d4
  g4 g8( a) h4 a g h\rest \bar "||" \break
  
  d8([^\markup{\hspace #-2.0 \bold \box 2} c8]) h([ c])
  d4 h c8([ h]) a([ h]) c4 a
  d8([ c]) h([ a]) a4( g8 a h c) a([ h]) g4 h4\rest \bar "||" \break
  \partial 2
  d4^\markup{\hspace #-2.0 \bold \box 3} d 
  c8 h c([ a]) e'4 e d8 c d([ h]) a8([ h]) c([ e]) d4 c h h4\rest \bar "||" \break

  d4^\markup{\hspace #-2.0 \bold \box 4} h8([ c])
  d h e([ d]) c4 a8([ h]) c a d([ c])
  h4 h e( d8 c h4) a4 h h4\rest \bar "||" \break
  
  h4(^\markup{\hspace #-2.0 \bold \box 5} a) a8([ h])
  c4 a h h8([ c]) d4 h
  h4( a) a8([ h]) c4 c h h\rest \bar "||" \break
  
  h4^\markup{\hspace #-2.0 \bold \box 6} h8([ c])
  d4 c8( h) a4 a8([ h]) c4 h8( a)
  h4 h8( c) d4 e8 e d4 c h4 h\rest \bar "||" \break
  
  h4^\markup{\hspace #-2.0 \bold \box 7} h h a
  c4 c c h \time 3/4
  d4( c) h e( d) c h( c8 d)  c4 h h2\rest \bar "||" \break
  \time 4/4
  d4^\markup{\hspace #-2.0 \bold \box 8} d
  c16([ h]) a([ g]) fis4
  e'4 e d16([ c]) h([ a]) g8([ h])
  d8([ h]) g([ h]) c16([ d e d] f[ e d c] h4)
  a h h\rest \bar "||" \break
  
  g4^\markup{\hspace #-2.0 \bold \box 14} 
  a8( fis) g4 g a8( h16 c) h8( a) g4 g4
  e4 g8( fis16 e) d4 d \bar "||" \break
  \partial 2
  e8([^\markup{\hspace #-2.0 \bold \box 15} fis]) g( a)
  h8 h e8([ fis]) g8( fis16 e) dis8 dis
  e8([ h c]) a h([ g a]) fis
  h4 a g h4\rest \bar "||" \break
  
  h8(^\markup{\hspace #-2.0 \bold \box 18} c8) d4
  e8([ d]) c([ h]) a( h) c4
  d8([ c]) h([ a]) h([ d]) c([ h])
  e4 d8 c h4 a h h\rest \bar "||" \break
  
  
  \bar "|."
}

altMusic = \relative c' {
  g' g8( a) h4 g4 
  fis e8( fis8) e4 d4
  g4 g8( a) g4 fis g h\rest

  h8([ a]) g([ a]) h4 g4
  a8([ g]) fis([ g]) a4 fis4
  h8([ a]) g([ fis]) fis2( fis4) fis g h\rest

  h4 h a8 g a([ fis8]) c'4 c h8 a h([ g]) 
  fis8([ g]) a([ c]) h4 a g h\rest

  h4 g8( a) h[ g] c( h) a4 fis8( g) a[ fis] h( a)
  g4 g4 c4( h8 a8 g4) fis g h4\rest
  
  g4( fis) fis8([ g]) a4 fis g4 g8([ a]) h4 g
  g4( fis) fis8([ g]) a4 a g4 h\rest  
  
  g4 g8([ a]) h4 a8( g) fis4 fis8([ g]) a4 g8( fis)
  g4 g8([ a]) h4 c8 c h4 a g4 h\rest
  
  g4 g g fis a a a g 
  h( a) g c( h) a g( a8[ h]) a4 g h2\rest
  
  h4 h a16([ g]) fis([ e]) d4
  c'4 c h16([ a]) g([ fis]) g4
  h8([ g]) g4 a16([ h c h] d[ c h a] g4) fis g h\rest
  
  g4 a8( fis) g4 g 
  fis8( g16 a) g8( fis) e4 e
  e4 e8( d16 c) h4 h
  
  e8([ fis]) g( fis) g g h4 e8( d16 c) h8 h
  h8([ g a]) fis g([ e fis]) fis g4 fis e h'\rest
  
  g8( a) h4 c8([ h]) a([ g]) fis( g) a4 h8([ a]) g([ fis])
  g([ h]) a([ g)] c4 h8 a g4 fis g h\rest
  
}

tenorMusic = \relative c' {
  g4 g8( a) h4 g4 d4 e8( fis8) e4 d4
  g4 g8( a) g4 d g d\rest

  g4 g g g d d d d
  g g d2( d4) d g d\rest

  g4 g d8 d d4 g g g8 g g4 d d d d g d\rest

  g4 g g8 g g4 d4 d d8 d dis4
  e4 e g( fis8 e d4) d g d\rest
  
  g4( d) d d d g g g g g4( d) d d d g d\rest
  
  g4 g g g d d d d g g g g8 g g4 fis g d\rest
  
  g4 g g d d d d g g2 g4 g2 g4 g2 d4 g d2\rest
  
  g4 g d8 d d4 g g d8 d g4
  g4 g d2( d4) d g d\rest
    
  g4 a8( fis) g4 g d4 d e e c4 c g g 
  
  e'8([ fis8]) g( fis) e e g([ a]) h( g16 fis) fis8 fis
  d1\rest e16([ fis]) g([ a]) h8 h, e4 d\rest
  
  g4 g g g d d d d 
  g4 g g g8 fis g4 d g d\rest
  
}

bassMusic = \relative c' {
  g4 g8( a) h4 g4 d4 e8( fis8) e4 d4
  g4 g8( a) g4 d g d\rest

  g4 g g g d d d d g g d2( d4) d g d\rest

  g4 g d8 d d4 c c g'8 g g4 d d d d g d4\rest

  g4 g g8 g g4 d4 d d8 d dis4
  e4 e c8( a h c d4) d g d\rest
  
  g4( d) d d d g g g g g4( d) d d d g d\rest
  
  g4 g g g d d d d g g g c,8 c d4 d g4 d\rest
  
  g4 g g d d d d g g2 g4 g2 g4 g2 d4 g d2\rest
  
  g4 g d8 d d4 c4 c d8 d g4
  g4 g d2( d4) d g d\rest
  
  g4 a8( fis) g4 g d4 d e e c4 c g g
  
  e'8([ fis8]) g( fis) e8 e e4 e h8 h
  d1\rest e16([ fis]) g([ a]) h8 h, e4 d\rest
  
  g4 g g g d d d d g4 g c, d8 d d4 d g d\rest
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
   \tempo 4 = 50
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
