\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Herr, ich habe Dich gerufen"
  subtitle = "Psalm 141, 1-2"
  subsubtitle = "5. Ton"
  %composer = "nach N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  %\key as \major
  \key g \minor
  %\time 2/4
  %\partial 2.
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOn
}

womenWords = \lyricmode {
  Herr! Zu Dir ha -- be ich ge -- ru -- fen,
  er -- hö -- re mich, er -- hö -- re mich, gro -- ßer Gott!
  Hö -- re auf mei -- ne Stim -- me, 
  wenn ich zu Dir ru -- fe!
  Mein Bitt -- ge -- bet sei ein Räu -- cher -- op -- fer
  vor Dei -- nem An -- ge -- sicht;
  das Er -- he -- ben mei -- ner Hän -- de,
  ein A -- bend -- op -- fer;
  er -- hö -- re mich, gro -- ßer Gott!
}

menWords = \lyricmode {
  
}

sopMusic = \relative c'' {
  g^\fermata b4\rest g a b b b a g( a8 b) a4 g f4.( e8) f4( g) g2 b4\rest
  g b8( c4 d8) b([ a]) b( c) b4.(a8 b a) g4 g4.^\fermata b8\rest
  b4 c8( d) b( c8) b4.( a8) g([ a]) b4 b
  b8( a) g4 b8([ c]) b( a) b4.(a8 b a g4) g2
  g4( a) b a g2 
  \partial 2 b4 b
  c b8( a) b4 c8( d) b( c8) b4. a8 g[ a] b2
  f4 g b8( a) g4 b8( c4 d8 b a) b([ c]) b2 b4
  g4 b4 a8( f) g4 g b4\rest
  f4 g8([ f]) g( a) b4 
  \partial 2 c4( d
  b8 c b4. a8) b([ a]) g2^\fermata
  \bar "|."
}

altMusic = \relative c'' {
  g4 b4\rest g a g g g f es2 f4
  g f4.( e8) f4( g) g2 b4\rest
  g4 g2 g4 g g2. g4 g4. b8\rest
  g4 a8( b) g( a) g2 g4 g4
  g4 g g g g g4.( f8 g f g4) g2
  g4( a) g f g2
  g4 g a g8( f) g4 a8( b) g4 g4. g8 g8[ a] g2
  f4 g g g g2( g4) g g2 g4
  g4 g a8( f) g4 g b4\rest
  f4 g8([ f]) g( a) g4 a4( b
  g8 a g4. f8) g([ f]) g2
}

bassMusic = \relative c' {
  g4 r g f es es es d c2 c4
  c4 c2 c c r4 r
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}