\version "2.24.0"
\language "deutsch"

\paper {
  left-margin = 1.0\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  ragged-last-bottom=##f
  system-count = #2
}

% diacritice: ă â î ş ţ

\header {
  title = "Vom Himmel hoch"
  composer = "nach G. Musicescu / É. Méhul"
  tagline = ""
  meter = "Andante"
}

global = {
  \key c \major
  \time 4/4
  \autoBeamOff
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Vom Him -- mel hoch, Herr -- scher ü -- ber Al -- lem,
  ha -- be Er -- bar -- men mit dei -- nen Söh -- nen;
  Gib rei -- che Frucht, saf -- ti -- ge Wie -- sen;
  dei --  nen Söh -- nen schenk' dei -- ne Gna -- de.
  
  Vom Him -- mel hoch, Herr -- scher ü -- ber Al -- lem,
  ha -- be Er -- bar -- men mit dei -- nen Söh -- nen;
  Gib rei -- che Frucht, saf -- tige Wie -- sen
  dei -  nen Söh - nen schenk' dei -- ne Gna -- de.
}

sopWordsThree = \lyricmode {
  Vom Him -- mel hoch, Herr -- scher ü -- ber Al -- lem,
  ha -- be Er -- bar -- men mit dei -- nen Söh -- nen;
  Gib rei -- che Frucht, saf -- ti -- ge Wie -- sen;
  dei --  nen Söh -- nen schenk' dei -- ne Gna -- de.
}

tenWords = \lyricmode {
  De sus din cer, Tu, Stă -- pân a toa -- te, ai în -- du -- ra -- re de-ai 
  Tăi fii, dă rod bo -- gat şi câm -- pii mă -- noa -- se fi -- i -- lor Tăi, 
  dă mi -- la Ta.
  De sus din cer, Tu, Stă -- pân a toa -- te, ai în -- du -- ra -- re de-ai 
  Tăi fii, dă rod bo -- gat şi câm -- pii mă -- noa -- se fi -- i -- lor Tăi, 
  dă mi -- la Ta.
}

bassWords = \lyricmode {
  Vom Him -- mel hoch, Herr -- scher ü -- ber Al -- lem,
  ha -- be Er -- bar -- men mit dei -- nen Söh -- nen;
  Gib rei -- che Frucht, saf -- ti -- ge Wie -- sen;
  dei --  nen Söh -- nen schenk' dei -- ne Gna -- de.
}

stanzaTwoMen = \lyricmode {
  %\set stanza = ""
  De sus din cer, Tu, Stă -- pân a toa -- te, ai în -- du -- ra -- re
  de-ai Tăi fii, dă rod bo -- gat şi câm -- pii mă -- noa -- se 
  fi -- i -- lor Tăi, dă mi -- la Ta.
}

sopMusicOne = \relative c'' {
  g2^\mf a4. h8 | c1 | c4. c8 f4 f4 | e2 e | c2 d4. d8 | e2 e2 | c2 f4 f | d2 d
  | g,2 a4. h8 | c1 | c2 f4. f8 | e2 e | d2 d | e2 e | c2 d4 d4 | c2 c4 h\rest \bar"||"
    
}

sopMusic = \relative c'' {
  h1\rest 
  g2^\mf a4. h8 | c1 | c4. c8 f4 f4 | e2 e | c2 d4. d8 | e2 e2 | c2 f4 f | d2 d
  h1\rest
  g2 a4. h8 | c1 | c2 f4. f8 | e2 e d2 d | e2 e | c2 d4 d4 | c2 c
  \bar"||"
  
  %r1 c2 d4. e8 f1 e4. e8 e2
  %c4. c8 f4 f4 | e2 e4 r
  %d2 d4 d4 | e1 | c2 d4 d4 | c1 \fermata \bar"|."  
}

womenMusicTwo = \relative c'' {
  g2^\mf a4. h8 | c1 | g2 a4. h8 | c1 | c4. c8 f4 f4 | e2 e4 r4 | c2 d4. d8 | 
  e2 e2 | c2 f2 | d1 | g,2 a4. h8 | c1 | g2 a4. h8 | c1 | c4. c8 f4 f4 | 
  e2 e4 r4 | d2 d4 d4 | e1 | c2 d4 d4 | c2 r2 \bar"|."
}

altMusicTwo = \relative c'' {
  g2 a4. g8 | g1 | g4. g8 c4 c4 | c2 c | c2 h4. h8 | c2 c2 | a2 a4 a | h2 h
  | g2 a4. g8 | g1 | g2 c4. c8 | c2 c | a2 a | gis2 gis | a2 h4 h4 | c2 c4 r
}

altMusic = \relative c'' {
  h1\rest
  g2 a4. h8 | \once \hide c1 | c4. c8 c4 c4 | c2 c | c2 h4. h8 | c2 c2 | a2 a4 a | h2 h
  %g2 a4. g8 | g1 | g4. g8 c4 c4 | c2 c | c2 h4. h8 | c2 c2 | a2 a2 | h1
  h1\rest
  g2 a4. h8 | \once \hide c1 | c2 c4. c8 | c2 c a2 a | gis2 gis | a2 h4 h4 | c2 c
  %g2 a4. g8 | g1 | g4. g8 c4 c4 | c2 c | a2 a4 a4 | gis1 | a2 h4 h4 | c1 
} 	

tenorMusic = \relative c' {
  r1 c2^\mf d4. e8 f1 e4. e8 e4 e c1 c2 r
  c2 d4. d8 | e2 e2 c2 f2 | d1
  r1 c2 d4. e8 f1 e4. e8 e4 e c1 c2 r
  d2 d4 d4 | e1 | c2 d4 d4 | c1 \fermata
  
  
  %r1 r g2 a4. h8 | c1 c4. c8 c4 c c2 c
  %c2 h4. h8 | c2 c2 | a2 a2 | h1
  %r1 r g2 a4. h8 | c1 c4. c8 c4 c c2 c4 r
  %a2 a4 a4 | gis1 | a2 h4 h4 | c1  
}

bassMusic = \relative c' {
  g2^\mf a4. h8 | c1 c2. c4 c2 c c c
  %a2 g4. g8 g2 g f f g1
  a2 g4. g8 c,2 c f d4 d g2 g
  g2 a4. h8 | c1
  %c,4. c8 c4 c c1 c2 r d2 d4 d e1 f2 g4 g c,1 \fermata  
  c2 c4. c8 c1 c2 r f,2 f e2 e a2 g4 g c,2 c
  \bar"|."
}  	

myScoreOne = \new Score <<
  \new ChoirStaff <<
    \new Voice { \global \sopMusicOne }   
    \addlyrics { \sopWords }
  >>
>>

myScoreTwo = \new Score <<
  \set Score.currentBarNumber = #17
  %\bar ""
  \new ChoirStaff <<
    \new Voice { \global \sopMusicOne }
    \addlyrics { \sopWords }
    \new Voice { \global \altMusicTwo }
  >>
>>

myScoreThree = \new Score <<
   \set Score.currentBarNumber = #33
   %\bar ""
   \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \global \voiceOne \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \sopWordsThree }
     \new Voice { \global \voiceTwo \altMusic }  
     %\addlyrics { \sopWordsThree }
    >>
    
    %\new Staff <<
     %\clef "G_8"
     %\new Voice { \global \tenorMusic }   
     %\addlyrics { \tenWords }
    %>>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      %\new Voice { \voiceTwo \global \bassMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

\score {
  \myScoreOne
  \layout { }
}

\score {
  \myScoreTwo
  \layout { indent = 0\cm }
}

\score {
  \myScoreThree
  \layout { indent = 0\cm }
}

midiOutput = \midi {
  \tempo 4 = 70
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScoreOne
  \midi { \midiOutput }
}

\score {
  \myScoreTwo
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusicTwo }
  \midi { \midiOutput }
}

\score {
  \myScoreThree
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

%\score {
 % \new Voice { \global \tenorMusic }
 % \midi { \midiOutput }
%}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}