\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Deschideți mari ale cerului porți"
  subtitle = " "
  composer = \markup \center-column { "Chr. W. Gluck" \small 
  "(1714 – 1787)" }
  meter = "Maestoso"
  tagline=""
}

global = {
  \key f \major
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Des -- chi -- deți mari a -- le ce -- ru -- lui porți!
  Des -- chi -- deți mari a -- le ce -- ru -- lui porți,
  ca-m -- pă -- ra -- tul sla -- vei să in -- tre.
  Ci -- ne, ci -- ne es -- te-m -- pă -- ra -- tul sla -- vei?
  Dom -- nul a -- tot -- pu -- ter -- nic în lup -- te,
  Dom -- nul, Dom -- nul Sa -- va -- ot.
  A -- min! A -- min!
}
menWords = \lyricmode {
  
}

sopMusic = \relative c' {
  f2^\accent^\mf a4. a8 c2.^\accent^\< c8 c d2\! d4. d8 c1
  a2^\< c4. c8\! f2. f8 f f2 f4. f8 f2 \breathe
  c4 c c2^\accent( b4) b b2^\accent a4 b a2^\accent( g4. f8)
  f2.^\markup"Fine" b4\rest \bar"||"
  f2^\accent( g4.) g8 a2^\accent^\> f g2\! a4.^\< a8 b2\!( b4) b c2( b) a2. b4\rest
  c2 d4.^\< d8 f2\! e f2^\< c4\! \breathe
  d4 e2 e c d e2. f4 e2( d4.) c8 
  c1^\markup {
    \column {
      \line { \halign #+0.3 D.C. al Fine}
      \line { \halign #+1.5 e poi Coda}
    }
  } 
  \bar ":|."
  b1^\markup"Coda"^\p a d^\pp c1^\fermata
  \bar "|."
}

altoMusic = \relative c' {
  f2 f4. f8 a2. c8 c b2 b4. b8 a1
  f2 a4. a8 c2. c8 c d2 d4. d8 c2
  a4 g f2( g4) g g2 f4 g f2( e4. f8) f2. b4\rest
  f2( e4.) e8 f2 f e f4. f8 g2( g4) g g2( g) f2. b4\rest
  g2 g4. g8 d'2 c c c4 c c2 c c h c2. c4
  c2( h4.) c8 g1 f f b a
}

tenorMusic = \relative c {
  f2 f4. f8 f2. f8 f f2 f4. f8 f1
  f2 f4. f8 a2. a8 a b2 b4. b8 f2
  f4 e d2( d4) d e2 f4 d c2( c4. f8) f2. d4\rest
  d2( c4.) c8 f2 f c c4. c8 d2( g4) f e1 f2. d4\rest
  e2 g4. g8 g2 g a a4 a g2 g g g g2. a4
  g2( f4.) e8 e1 d c f f
}

bassMusic = \relative c {
  f2 f4. f8 f2. f8 f b,2 b4. b8 \once \hide f'1
  f2 f4. f8 f2. f8 f b2 b4. b8 f2
  f4 e d2( g,4) g c2 d4 b c2( c4. f8) f2. d4\rest
  d2( c4.) c8 f2 f c4( b) a4. a8 g2( g'4) f \once \hide e1 f2. d4\rest
  c2 h4. h8 h2 c f f4 f c2 c e d c2. f4
  g2( g,4.) c8 c1 b f b f
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altoMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}