\version "2.24.0"
\language "deutsch"


\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Gib mir ein lichtes Gewand"
  %subtitle = "glasul 5"
  %composer = "după Ghelasie Basarabeanul"
  arranger = "nach Tudose Vasile"
  %meter = "Moderato"
  tagline=""
}

global = {
  \autoBeamOn
  \key f \major
  %\time 2/4
  \partial 2.
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Gib mir ein lich -- tes Ge -- wand,
  der Du von Licht um -- ge -- ben bist wie
  von ei -- nem Kleid, Chri -- stus, voll 
  Er -- bar -- men, un -- ser Gott.
  
}

tenorWords = \lyricmode {
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 2.
  %Şi a -- cum şi pu -- ru -- rea \skip 4 şi în ve -- cii ve -- ci -- lor. A -  min.
 
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  %Şi a -- cum şi pu -- ru -- rea şi în ve -- cii ve -- ci -- lor. A --  min.
}

sopMusic = \relative c' {
 f4 f f g( f) e f g2 b4( a) g f g g  
 a g g2 f4 e d c d8( e8 f2) b4\rest
 g4 g a g4 f8( g f e) d4( e)
 f( g) f( e) f2
 \bar "|."
}

altMusic = \relative c' {
  f4 f f g( f) e f e2
  g4( f) e d e e f e e2
  f4 e d c d8( e8 f2) b4\rest
  e,4 e f e d8( e d c) d4( e) 
  d4( e) d4( e) f2
}

tenorMusic = \relative c {
  f4 f f g( f) e f c'2
  c2 c4 c c c c b b2
  a4 g f g f8( g a2) d,4\rest
  b'4 b c b a8( b a g)
  f4( g) a( b) a( g) a2
}


bassMusic = \relative c {
  f4 f f g( f) e d c2
  c2 c4 d c c f c c2
  d4 a b a b( f'2) r4
  c4 c c c c2 c c c <f f,>2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      %\addlyrics { \womenWords }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff = "staff" <<
      \clef bass
      %\new Voice { \global \voiceOne \tenorMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\addlyrics { \tenorWords }
      %\new Voice { \global \voiceTwo \bassMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
  %\layout { #(layout-set-staff-size 15) }
}  

midiOutput = \midi {
    \tempo 4 = 50
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}