\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ce bine e când frații"
  subsubtitle = "Wie leblich ist's hienieden"
  composer = \markup \center-column { "melodie tradițională" \small
  "(Lowell Mason?)" }                                    
  poet = \markup \center-column { "Friedrich Gottlob Wetzel" \small
  "(1779 - 1819)" }
  %meter = "Adagio"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  %\time 3/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOn
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Ce bi -- ne e când fra -- ţii în Dom -- nul se u -- nesc,
  și-n dra -- gos -- te, cu to -- ţii, pe Dom -- nul prea -- mă -- resc,
  și-n dra -- gos -- te, cu to -- ţii, pe Dom -- nul prea -- mă -- resc.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
   Ca ro -- ua, ce se var -- să pe câm -- puri şi prin văi,
   și bi -- ne -- cu -- vân -- ta -- rea că -- dea -- va __ pes -- te ei,
   și bi -- ne -- cu -- vân -- ta -- rea că -- dea -- va __ pes -- te ei.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Se va -- no -- i, o -- da -- tā, prin ei, lo -- ca -- șul sfânt,
  toți fe -- ri -- ciți și ti -- neri vor fi pe-a -- cest pă -- mânt,
  toți fe -- ri -- ciți și ti -- neri vor fi pe-a -- cest pă -- mânt.
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  Va mer -- ge spre lu -- mi -- nā, a -- tunci, ori -- ce po -- por,
  va fi nu -- mai o tur -- mă, o tur -- mā și-un Păs -- tor, 
  va fi nu -- mai o tur -- mă, o tur -- mā și-un Păs -- tor.
}

womenWordsFive = \lyricmode {
  \set stanza = "5."
  
}

womenWordsSix = \lyricmode {
  \set stanza = "6."
  
}

menWords = \lyricmode {
  
}

sopMusic = \relative c' {
  c4
  a'4. a8 g4 a f2 c4 c c'4. c8 b4 c a2.
  f4 d' d <f d> d c2 a4 c c b8( a) b4 c a2.
  f4 d' d <f d> d c2 a4 c c b8( a) b4 c a2.
  
  \bar "|."
}

altMusic = \relative c' {
  c4 f4. f8 e4 c c2 c4 c f4. f8 f4 f f2.
  f4 f f f f f2 f4 f a g8( f) g4 e f2.
  f4 f f f f f2 f4 f a g8( f) g4 e f2.
}

tenorMusic = \relative c' {
  c4 c4. c8 c4 c a2 a4 c c4. c8 d4 c c2.
  a4 b b b b a2 c4 c c c c c c2.
  a4 b b b b a2 c4 c c c c c c2.
}

bassMusic = \relative c {
  c4 f4. f8 c4 c f2 f4 c a'4. a8 g4 c, f2.
  f4 b, b d b f'2 f4 a c c c, c f2.
  f4 b f d b f'2 f4 a c c c, c f2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     \addlyrics { \womenWordsFour }
     \addlyrics { \womenWordsFive }
     \addlyrics { \womenWordsSix }
     \new Voice { \voiceTwo \global \altMusic }
     %\addlyrics { \womenWordsOne }
     
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}