\version "2.24.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 23))
  %markup-system-spacing = #'((basic-distance . 19))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  ragged-last-bottom=##f
  system-count = #10
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Axionul Născătoarei de Dumnezeu"
  subtitle = "glasul 8"
  composer = "Ion Popescu-Pasărea"
  arranger = "arm. după N. Moldoveanu"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \override Staff.TimeSignature.stencil = ##f
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
  \cadenzaOn
}

womenWords = \lyricmode {
  Cu -- vi -- ne -- se cu __ a -- de -- vă -- rat
  să te fe -- ri -- cim Năs -- că -- toa -- re __ de __ Dum -- ne -- zeu,
  Cea pu -- ru -- rea fe -- ri -- ci -- tă
  şi prea ne -- vi -- no -- va -- tă
  şi Mai -- ca Dum -- ne -- ze -- u -- lui nos -- tru.
  Ce -- ea ce eşti mai cin -- sti -- tă de -- cât he -- ru -- vi mii
  şi mai mă -- ri -- tă făr' de-a -- se -- mă -- na -- re
  de -- cât se -- ra -- fi -- mii;
  Ca -- re __ fă -- ră de stri -- că -- ciu -- ne
  pe Dum -- ne -- zeu Cu -- vân -- tul, Cu -- vân -- tul ai __ năs -- cut,
  pe ti -- ne cea cu __ a -- de -- vă -- rat
  Năs -- că -- toa -- re de Dum -- ne -- zeu __
  te mă -- rim, te __ mă -- rim.
}

menWords = \lyricmode {
  Cu -- vi -- ne -- se cu a -- de -- vă -- rat
  să te fe -- ri -- cim Năs -- că -- toa -- re de Dum -- ne -- zeu,
  Cea pu -- ru -- rea fe -- ri -- ci -- tă
  şi prea ne -- vi -- no -- va -- tă
  şi Mai -- ca Dum -- ne -- ze -- u -- lui nos -- tru.
  Ce -- ea ce eşti mai cin -- sti -- tă de -- cât he -- ru -- vi mii
  şi mai mă -- ri -- tă făr' de-a -- se -- mă -- na -- re
  de -- cât se -- ra -- fi -- mii;
  Ca -- re __ fă -- ră de stri -- că -- ciu -- ne
  pe Dum -- ne -- zeu Cu -- vân -- tul, Cu -- vân -- tul ai năs -- cut,
  pe ti -- ne cea cu a -- de -- vă -- rat
  Năs -- că -- toa -- re de Dum -- ne -- zeu
  te mă -- rim, te __ mă -- rim.
}

sopMusic = \relative c'' {
  \accidentalStyle forget

  % Cuvine-se cu adevărat
  c4^\mf \bar "|"
  d8([ es] d4) c c \bar "|"
  a( c) \bar "|"
  b8([ a] g4) a b \bar "|"
  c2

  % să te fericim Născătoare de Dumnezeu
  c4 c \bar "|"
  d2 e8([ f] e4) \bar "|"
  f2 c4 c \bar "|"
  f8([ e f d]) c([ d] c4) \bar "|"
  b8([ a] g4) \bar "|"
  a4( b) a( g) \bar "|"
  f2.

  % cea pururea fericită
  c'4 \bar "|"
  d8([ es] d4) c c \bar "|"
  a c \bar "|"
  b8([ a] g4) a 

  % şi prea nevinovată
  b \bar "|"
  c8.([ des16 c8]) b c4 d \bar"|"
  f4( e des c) \bar"|"
  c2.

  % şi Maica Dumnezeului nostru.
  c4 \bar "|"
  d2( e8[ f e d] \bar "|"
  e4. f8) f2 \bar "|"
  c4 c \bar "|"
  f8([ e f d)] c([ d] c4) \bar "|"
  b8([ a] g4) \bar "|"
  a4( b a g) \bar "|"
  f2. h4\rest \bar "|"

  % Ceea ce eşti mai cinstită decât heruvimii
  d2^\mp b4 d \bar "|"
  c2 a4 c \bar "|"
  b8([ a] g4) a4 b \bar "|"
  c8([ des c b]) c4 d \bar "|"
  f4( e des c) \bar"|"
  c2.

  % şi mai mărită făr' de-asemănare
  c4 \bar "|"
  d2 e8([ f e d]) \bar "|"
  e4.( f8) f2 \bar "|"
  c4 c d e \bar "|"
  f8([ e f d]) c([ d] c4) \bar "|"

  % decât serafimii;
  b8([ a]) g4 a4 b \bar "|"
  a( g f e) \bar "|"
  f2. h4\rest \bar "|"

  % care fără stricăciune
  d2^\mf b4( d) \bar "|"
  c2 a4( c) \bar "|"
  b8([ a] g4) a4 b \bar "|"
  c4( des) c4. 

  % pe Dumnezeu Cuvântul ai născut,
  c8 \bar "|"
  des8([ c]) h4 \bar"|"
  c4 des  \bar"|"
  f8([ g] f4) e des \bar"|"
  c2 b4( des) \bar"|"
  c4( b) as( g) \bar"|"
  f2.

  % pe tine cea cu adevărat
  c'4 \bar "|"
  d8([ es] d4) c c \bar "|"
  a( c) b8([ a] g4) \bar "|"
  a b \bar "|"
  c2 

  % Născătoare de Dumnezeu
  c4 c4 \bar "|"
  d2( e8[ f e d] \bar "|"
  e4. f8) f4. c8 \bar "|"
  c4 c \bar "|"
  d8([ es d c])

  % te mărim, te mărim
  b4 a \bar "|"
  g2 \bar "|"
  c2^\markup { \italic "rall..." } c \bar "|"
  f2. \fermata h,4\rest  
  \bar "|."
}

altMusic = \relative c'' {
  \accidentalStyle forget

  % Cuvine-se cu adevărat
  a4 b8([ c] b4) a a f( a) g8([ f] e4) f g
  a2 

  % să te fericim Născătoare de Dumnezeu
  a4 a b2 c4( b) a2 a4 a c4.( b8) a([ b] a4)
  g8([ f] e4) f2 f4( e) f2.

  % cea pururea fericită
  a4 b8([ c] b4) a a f a g8([ f] e4) f 

  % şi prea nevinovată
  g a8.([ b16 a8]) g a4 b a( c b a) a2.

  % şi Maica Dumnezeului nostru.
  a4 b8([ g a b] c[ a b d] c2) c a4 a c4.( b8)
  a([ b] a4) g8([ f] e4) f2.( e4) f2. h4\rest

  % Ceea ce eşti mai cinstită decât heruvimii
  b2 f4 b a2 f4 a g8([ f] e4) f g a8([ b a g]) a4 b
  a( c b a) a2.

  % şi mai mărită făr' de-asemănare
  a4 b2 c c c a4 a b c c4.( b8) a([ b] a4) 
  
  % decât serafimii;
  g8([ f]) e4 f f f( e f e) f2. h4\rest

  % care fără stricăciune
  b2 f4( b) a2 f4( a) g8([ f] e4) f g a( b) a4.

  % pe Dumnezeu Cuvântul ai născut,
  a8 b8([ a]) gis4 a b a( c) c b a2 g4( b)
  a( g) f( e) f2.

  % pe tine cea cu adevărat
  a4 b8([ c] b4) a a f( a) g8([ f] e4) f g a2 

  % Născătoare de Dumnezeu
  a4 a b2( c c) c4. a8 a4 a b8([ c b a])
  
  % te mărim, te mărim
  g4 f e2 a4( g) a( b) a2. h4\rest
}

tenorMusic = \relative c' {
  \accidentalStyle forget

  % Cuvine-se cu adevărat
  a4 b8([ c] b4) a a f2 c f4 f f2
  
  % să te fericim Născătoare de Dumnezeu
  f4 f b2 g f f4 f a4.( b8) f2 c f4( d) c2 f2.

  % cea pururea fericită
  a4 b8([ c] b4) f f f f c2 f4

  % şi prea nevinovată
  f4 f4. f8 f4 f f( a b f) f2. d4\rest

  % şi Maica Dumnezeului nostru.
  d2\rest d4\rest d8\rest f
  g4.( a8) a2 f4 f a4.( b8) f2 c f4( d c2) f2. d4\rest
  
  % Ceea ce eşti mai cinstită decât heruvimii
  f2 d4 f f2 f4 f c2 f4 f f2 f4 f f( a b f) f2.

  % şi mai mărită făr' de-asemănare
  f4 b2 g c4.( b8) a2 f4 f b b a4.( b8) f2

  % decât serafimii;
  c4 c f d 
  \once \override NoteColumn.force-hshift = #0.5
  c1 f2. d4\rest

  % care fără stricăciune
  f2 d4( f) f2 f c f4 f f2 f4.


  % pe Dumnezeu Cuvântul ai născut,
  f8 f4 f f f f( a) a b f2 f f f4( c) f2. 

  % pe tine cea cu adevărat
  a4 b8([ c] b4) f f f2 c f4 f f2

  % Născătoare de Dumnezeu
  f4 f b2( g c4. b8) a4. f8 f4 f f2
  
  % te mărim, te mărim
  e4 f c2 f4( e) f( g) f2. d4\rest
}

bassMusic = \relative c' {
  \accidentalStyle forget

  a4 b8([ c] b4) a a f2 c f4 f f2
  
  % să te fericim Născătoare de Dumnezeu
  f4 f b2 g f f4 f f2 f c f4( b,) c2 f2.

  % cea pururea fericită
  a4 b8([ c] b4) f f f f c2 f4

  % şi prea nevinovată
  f4 f4. f8 f4 f f( a b f) f2. d4\rest

  % şi Maica Dumnezeului nostru.
  d2\rest d4\rest d8\rest f
  c4.( f8) f2 f4 f f2 f c f4( b, c2) f2. d4\rest
  
  % Ceea ce eşti mai cinstită decât heruvimii
  b2 b4 b f'2 f4 f c2 f4 f f2 f4 f f( a b f) f2.

  % şi mai mărită făr' de-asemănare
  f4 b2 g c4.( c,8) f2 f4 f b g f2 f

  % decât serafimii;
  c4 c f d c1 f2. d4\rest

  % carea fără stricăciune
  b2 b f' f c f4 f f2 f4.

  % pe Dumnezeu Cuvântul ai născut,
  f8 f4 f f f f2 f4 f f2 f f f4( c) f2. 

  % pe tine cea cu adevărat
  a4 b8([ c] b4) f f f2 c f4 f f2

  % Născătoare de Dumnezeu
  f4 f b2( g c4 c,) a'4. f8 f4 f f2
  
  % te mărim, te mărim
  e4 f c2 f4( e) d( c) f,2. d'4\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \womenWords }
     \new Voice { \voiceTwo \global \altMusic }
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      \addlyrics { \menWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 55
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}