\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Halleluja"
  subtitle = "(Variante)"
  %composer = "din Irlanda"
  %meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key g \major
  \time 6/8
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOn
}

womenWords = \lyricmode {
  Hal -- le -- lu -- ja, __
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja, __
  Hal -- le -- lu -- ja.
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja.
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja.
}

menWords = \lyricmode {
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja.
  Hal -- le -- lu -- ja.
  Hal -- le -- lu -- ja.
}

sopMusic = \relative c' {
  d4^\markup{\hspace #0 \bold \box 1}
  ( g8) g4( a8) h8.( a16 g8) a4.
  c4( a8) h8.( a16 g8) a8( g^\markup \large "aus Irland"
  e) d4.
  \break
  d4( g8) g4( a8) h8.( a16 g8) a4.
  c4( a8) h8.( a16 g8) g8( a fis) g4 h8\rest 
  \bar "||"
  \break
  \time 4/4
  \partial 2
  g4^\markup{\hspace #0 \bold \box 2}
  g a( fis) g2 h4 h c( a) h2
  d4 d e( d8 c h2^\markup \large "     nach H. Alfejew"
  a) g4. h8\rest
  \bar "||"
  \break
  \partial 2
  g4^\markup{\hspace #0 \bold \box 3}
  g a fis g2 h4 h c a h2
  d4 d g( fis8 e d4 c h2 a) g1
  \bar "|."
}

altMusic = \relative c' {
  h4( d8) e4( fis8) g4. fis8.( e16 fis8)
  g4( a8) g4. e4( c8) a4.
  h4( d8) e4( fis8) g4. fis8.( e16 fis8)
  g4( a8) g4. e4( d8) d4 h'8\rest
  g4 g a( fis) g2 g4 g a( fis) g2
  h4 h c(h8 a g2 fis) g4. h8\rest
  g4 g a( fis) g2 g4 g a( fis) g2
  h4 h h( g2. g2 fis) d1
}

bassMusic = \relative c' {
  g4( fis8) e4( d8) g,4( h8) d4.
  e4( fis8) g4( h,8) c4( a8) d4.
  g4( fis8) e4( d8) g,4( h8) d4.
  e4( fis8) g4( h,8) c8( a d) g,4 r8
  r2 r1 r r2
  g'4 g c,2( d d) <g g,>4. r8
  r2 r1 r
  g4 g g8( fis e d g,4 a h c d1) <g g,>
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \womenWords }
     
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 60
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

%{
convert-ly.py (GNU LilyPond) 2.24.1  convert-ly.py: Processing `'...
Applying conversion: 2.23.1, 2.23.2, 2.23.3, 2.23.4, 2.23.5, 2.23.6,
2.23.7, 2.23.8, 2.23.9, 2.23.10, 2.23.11, 2.23.12, 2.23.13, 2.23.14,
2.24.0
%}
