\version "2.24.0"
%\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #2
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Halleluja"
  %subtitle = "glasul 1"
  composer = "nach N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  %\key as \major
  \key f \minor
  \time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}

womenWords = \lyricmode {
  Hal -- le -- lu -- ja, __
  Hal -- le -- lu -- ja,
  Hal -- le -- lu -- ja.
}

menWords = \lyricmode {
  A __
  Hal -- le -- lu __
  Hal -- le -- lu __
  Hal -- le -- lu -- ja.
}

sopMusic = \relative c' {
  f4^\p g^\< 
  as( bes\! as^\> g) 
  f(\! es) \breathe f g 
  as(^\< bes\! as^\> g8[ as)]\! f2 \breathe 
  bes8([^\mf as bes c)] as([ g as bes)]
  as([ bes as g] f[ g16^\> as] f4)\! 
  f2^\pp
  \bar "|."
}

altMusic = \relative c' {
  f4 f f2( f4 g) f( es) 
  f f f2( f4 g8[ as)] f2 
  f f f4.( es8 c4. des8) c2
}

tenorMusic = \relative c' {
  as4 bes c( des) c( bes) as( g) 
  as bes c( des) c( bes8[ c)] as2
  des c c4.( bes8) as4.( bes8) as2
}

bassMusic = \relative c {
  f2( f f f4 es) f4 f f2( f)
  f8 f16([ es)] des8([ c8]) bes2 f' f( c) f2 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 50
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}