\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Nun entlässest"
  subtitle = "Lobpreis des Simeon"
  subsubtitle = "(Lk 2, 29-32)"
  %composer = "nach N. Lungu"
  %meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  %\key as \major
  \key f \major
  %\time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}

womenWords = \lyricmode {
  Nun ent -- läs -- sest Du Dei -- nen Knecht,
  o, Herr, nach Dei -- nem Wil -- len in Frie -- den.
  Mei -- ne Au -- gen ha -- ben das Heil ge -- seh'n,
  das Du be -- rei -- tet hast vor al -- ler
  Völ -- ker __ An -- ge -- sicht.
  Ein Licht __ zur Er -- leuch -- tung der Hei -- den
  und zur Ver -- herr -- li -- chung
  Dei -- nes Vol -- kes Is -- ra -- el. __
}

menWords = \lyricmode {
  Nun ent -- läs -- sest Du Dei -- nen Knecht,
  o, Herr, nach Dei -- nem Wil -- len in Frie -- den.
  Mei -- ne Au -- gen ha -- ben das Heil ge -- seh'n,
  das Du be -- rei -- tet hast vor al -- ler
  Völ -- ker __ An -- ge -- sicht.
  zur Er -- leuch -- tung der Hei -- den
  Dei -- nes Vol -- kes Is -- ra -- el. __
}

sopMusic = \relative c' {
  f2 a4( b) c d c2 c4 a b c d2 b4\rest
  c4 b a b( a) g f g( a) f b4\rest
  f4 f a a d2 c4 c d d c2 \breathe
  f2 e4 c d d c 
  c4 d c b( a) g8( a b4) a g f2 b4\rest
  f a( b c d c2) c4 c d2 c4 c f2( e4 d) c \breathe
  c4 c c f2 e4( d) d2 c4 b a f b a g2( f4 e d e f2) 
  \bar "|."
}

altMusic = \relative c' {
  f2 f4( g) a a a2 a4 a b a a2 b4\rest
  a4 g a g( a) g f e( f) f b4\rest
  f4 f f f b2 a4 a b b a2 
  b2 c4 c b b a a4 a a g( a) g8( f g4)
  f e f2 b4\rest
  f4 f( g a b a2) a4 a b2 a4 a
  a2( a4 a) a a a a d2 c4( b) b2 a4 g f f
  g a g2( f4 e d e f2)
}

bassMusic = \relative c {
  f2 f f4 f f2 f4 f <b b,> f f2 r4
  f4 f f f2 f4 f c2 f4 r
  f4 f f f f2 f4 f b, b f'2
  
  f2 g4 f g g f f4 f f e( f) 
  c2 c4 c f2 r4 r r1 r2
  f4 f f2 f4 f b,( c d e) f r4 r2 r r r
  f4 f f f c c c2( c1 <f f,>2)
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}