\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Bine ești cuvântat"
  subtitle = "Troparul Rusaliilor"
  composer = \markup \center-column { "după Dimitrie Georgescu-Kiriac" \small 
  "(1866 – 1928)" }
  %meter = "Andante"
  tagline=""
}

global = {
  \key b \major
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Bi -- ne ești cu -- vân -- tat, Hris -- toa -- se, Dum -- ne -- ze -- ul __ nos -- tru,
  Cel ce prea -- în -- țe -- lepți pe pes -- cari ai a -- ră -- tat,
  tri -- mi -- țân -- du -- le Du -- hul Sfânt.
  Și prin -- tr-în -- șii lu -- mea ai vâ -- nat,
  Iu -- bi -- to -- ru -- le de oa -- meni, mă -- ri -- re __ Ți -- e.
}
menWords = \lyricmode {
  Bi -- ne ești cu -- vân -- tat, Hris -- toa -- se, Dum -- ne -- ze -- ul nos -- tru,
  Cel ce prea -- în -- țe -- lepți pe pes -- cari ai a -- ră -- tat,
  tri -- mi -- țân -- du -- le Du -- hul Sfânt.
  Și prin -- tr-în -- șii lu -- mea ai vâ -- nat,
  Iu -- bi -- to -- ru -- le de oa -- meni, mă -- ri -- re Ți -- e.
}

sopMusic = \relative c'' {
  b2 b4 a \time 2/4 b c \time 4/4 d2. \breathe c4 d c b b
  b8( c b a) g4( a) b( c b a) b2^\fermata
  b2 c4 b a b c2 c4 d es d c b c2
  c4 d es( d) c c b4( c) b( a) b2^\fermata
  b4 c \time 2/4 d d \time 4/4 f4 f es d c2 \breathe
  c4 d es es d c d2 c4 
  c b8( c b a) g4( a) b( c b a) b1^\fermata
  
  \bar "|."
}

altoMusic = \relative c'' {
  b2 b4 a b a b2. f4 f f f g g8( a g f) f2 f1 f2
  b2 c4 b a b a2 a4 b c b a b a2
  a4 b a( b) a a g( f) g( f) g2
  b4 a b b b b c b a2
  a4 b c c b a b( a) g 
  g g8( a g f) es4( f) f2( g4 a) \once \hide b1
}

bassMusic = \relative c' {
  b2 b4 a g f f2. f4 b, c d es f2 f b,1 b2
  b'2 c4 b a g f2 f4 f f g f g f2
  f4 f f2 f4 f b,2 b es2
  f4 f f f f f f g f2
  f4 f f f f f b,2 c4 c f2 f b,1 b
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      %\new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altoMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}