\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Răsunet blând de clopoței"
  subtitle = " "
  composer = \markup \center-column { "Muzică și versuri" \small
  "Pr. Cristian Alexandru" }
  %meter = "Maestoso"
  tagline=""
}

global = {
  \key g \major
  \time 6/8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Ră -- su -- net blând de clo -- po -- ței
  se-a -- ud ve -- nind pe drum;
  e săr -- bă -- toa -- re și e cânt,
  că-i sea -- ra lui Cră -- ciun.
  Bim bam.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  La peș -- te -- ra din Bet -- le -- em
  Hris -- tos ni s-a năs -- cut;
  păs -- tori și magi și în -- geri sfinți
  ve -- nind, L-au cu -- nos -- cut. 
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Și mai -- ca Sa-i cân -- ta în -- cet,
  în -- cet s-a -- doar -- mă lin,
  că-i Dum -- ne -- zeu și Fiu Prea -- sfânt
  al Ta -- tă -- lui din cer.  
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  La ca -- se-i săr -- bă -- toa -- re-a -- cum
  și oa -- me -- nii-s fru -- moși;
  c-a -- șa-i Cră -- ciu -- nul la ro -- mâni
  și-l prăz -- nu -- im vo -- ioși.
}

menWordsOne = \lyricmode {
  \set stanza = "1."
  
}

menWordsTwo = \lyricmode {
  \set stanza = "2."
  
}

menWordsThree = \lyricmode {
  \set stanza = "3."
  
}

sopMusic = \relative c' {
  \partial 8 d8^\p
  h'4 h8 c4 c8 h4 a8 g4 g8 a4 a8 a4 c8 h2 h8\rest
  g8 e'4 e8 d4 d8 c4 c8 h4 h8 a([ h]) c h4 a8 g4
  c8 h4.
  \bar "|."
}

altoMusic = \relative c' {
  d8
  h'4 h8 c4 c8 h4 a8 g4 g8 fis4 fis8 fis4 fis8 g2 h8\rest
  g8 c4 c8 h4 h8 a4 a8 g4 g8 fis([ g]) a g4 fis8 g4
  a8 g4.
}

bassMusic = \relative c {
  d8 g4 g8 a4 a8 g4 fis8 g4 g8 d4 d8 d4 d8 g2 r8
  g8 c,4 c8 g'4 g8 fis4 fis8 g4 g8 d4 d8 d4 d8 g4
  d8 g,4. 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      \addlyrics { \womenWordsFour }
      \new Voice { \voiceTwo \global \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      %\new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \menWordsOne }
      \addlyrics { \menWordsTwo }
      \addlyrics { \menWordsThree }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altoMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}