\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Eu sunt Învierea"
  subtitle = " "
  %subsubtitle = "glasurile 8, 1"
  composer =  \markup \center-column { "Ionel Gh. Brătianu"
   \small "(1885 - 1921)" }
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key es \major
  %\autoBeamOff
  %\time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Eu sunt În -- vi -- e -- rea și Vi -- a -- ța;
  cel ce cre -- de-n mi -- ne, viu, viu va fi
  de va și mu -- ri,  de va și mu -- ri,
  cel ce cre -- de-n mi -- ne, viu, viu va fi.
  
  A -- șa e -- ste Doam -- ne,
  Tu ești Hris -- tos 
  Cel ce ai ve -- nit în lu -- me!
}

menWords = \womenWords

sopMusic = \relative c'' {
  b4.^\p b8 c4 b g2^\> es f4.^\< f8 g4( as)\! b2. b4\rest
  b4. b8 c4 b g2 es f as4 d, es2. b'4\rest
  \repeat volta 2 {
    as4^\p as as g f2. b4\rest b4.^\< c8 b4 as\! g2. b4\rest
    as4.^\< as8 c4 c b2 es\! d2^\f c4 c b2. b4\rest
  }
  b4. b8 c4 b g2^\< es f g4. as8\! b2. b4\rest
  b4. b8 es4 d c2.^\< f4 es2\!( d) es1 ^\fermata
  \bar "|."
}

altMusic = \relative c'' {
  g4. g8 as4 g es2 es d4. d8 es4( f) g2. b4\rest
  g4. g8 as4 g es2 es f f4 f es2. b'4\rest
   f4 f f es d2. b'4\rest g4. as8 g4 f es2. b'4\rest
   f4. f8 f4 f f2 f b a4 a b2. b4\rest
  g4. g8 as4 g es2 es d es4. f8 g2. b4\rest
  g4. g8 g4 g as2. as4 g2( as) g1
}

tenorMusic = \relative c {
  es4. es8 es4 es es2 es b4. b8 es2 es2. d4\rest
  es4. es8 es4 es es2 es f d4 b es2. d4\rest
   b4 b d es b2. d4\rest es4. es8 es4 d es2. d4\rest
   f4. f8 es4 es d2 c f f4 f b2. d,4\rest
  es4. es8 es4 es es2 es b es4. es8 es2. d4\rest
  es4. es8 es4 es as2. f4 b2( b,2) es1
}

bassMusic = \relative c {
  es4. es8 es4 es es2 es b4. b8 es2 es2. d4\rest
  es4. es8 as,4 es' es2 es f b,4 b es2. d4\rest
   b4 b d es b2. d4\rest es4. es8 es4 b es2. d4\rest
   f4. f8 es4 es d2 c f f4 f b,2. d4\rest
  es4. es8 es4 es es2 es b es4. es8 es2. d4\rest
  es4. es8 es4 es as2. f4 b,2( b2) \once \hide es1
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}