\version "2.18.0"
\language "deutsch"


\paper {
  %system-system-spacing = #'((basic-distance . 16))
  %markup-system-spacing = #'((basic-distance . 16))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Câţi în Hristos"
  %subtitle = "glasul 5"
  %composer = "după Ghelasie Basarabeanul"
  arranger = "arm. după Ioan Bunescu"
  %meter = "Moderato"
  tagline=""
}

global = {
  \autoBeamOn
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Câți în Hris -- tos v-ați bo -- te -- zat,
  în Hris -- tos v-ați și-m -- bră -- cat.
  A -- li -- lu -- i -- a.
  \once \override LyricText.self-alignment-X = #-1
  "Mărire Tatălui şi Fiului şi Sfântului" 
  Duh. 
  \once \override LyricText.self-alignment-X = #-1
  "Şi acum şi pururea şi în vecii vecilor. A -" 
  \once \override LyricText.self-alignment-X = #-1
  min.
  %Mă -- ri -- re Ta -- tă -- lui şi Fi -- u -- lui şi Sfân -- tu -- lui Duh.
  %Şi a -- cum şi pu -- ru -- rea şi în ve -- cii ve -- ci -- lor. A -- min.
  În Hris -- tos v-ați și-m -- bră -- cat.
  A -- li -- lu -- i -- a.
  
  Câți în Hris -- tos v-ați bo -- te -- zat,
  în Hris -- tos v-ați și-m -- bră -- cat.
  A -- li -- lu -- i -- a.
}

tenorWords = \lyricmode {
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 2.
  %Şi a -- cum şi pu -- ru -- rea \skip 4 şi în ve -- cii ve -- ci -- lor. A -  min.
 
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  %Şi a -- cum şi pu -- ru -- rea şi în ve -- cii ve -- ci -- lor. A --  min.
}

sopMusic = \relative c'' {
 % Amin.
  c2^\mf c^\fermata
  \repeat volta 3 {
   c4^\p c8^\<  c c4\! a8([ b]) c4 d c2 
   d4 d d8([ f]) e([ d]) c([ b]) a([ b]) c2 
   c4 d c b a2^\fermata %\break  
  }
  \mark "                Mărire Tatălui "
  % Mărire Tatălui şi Fiului şi Sfântului Duh.
  \cadenzaOn
  c\breve \bar"|" d2 \bar"|" d\breve \bar"|" c2 \bar"|"
  \cadenzaOff
  
  %b8\rest d,8^\mf d d g^\accent f g a^\< b g\! a h 
  %c16([^\accent d c8]) b16([ a) g8]^\> a2\! \breathe

  % Şi acum şi pururea şi în vecii vecilor, amin.
  %d,4^\p d g^\accent f g^\accent a^\> a2
  %a4\! h^\< c h\! c8([ d]) c4^\> b8([ a])\! \breathe g4^\< a2\!
  %b2\rest b2\rest b2\rest b2\rest b2\rest   
  % Sfinte făr' de moarte
  d4 d d8([ f]) e([ d]) c([ b]) a([ b]) c2 
  c4 d c b a2^\fermata \bar "|."
  \mark "      Puternic "
  c4^\mf c8^\<  c c4\! a8([ b]) c4 d c2 
  d4^\f d d8([ f]) e([ d]) c([ b]) a([ b]) c2 
  c4^\p c8([ d]) c4 b a2^\fermata \bar "|."
}

altMusic = \relative c'' {
  a2 a
  a4 a8 a a4 f8([ g]) a4 b a2
  b4 b b8([ d]) c([ b]) a([ g]) f([ g]) a2
  a4 b a g f2
  a\breve b2 b\breve a2
  %d,4 d d d d d d d d d f e2 e4 e f2
  %b8\rest d,8 d d g f g a g g f f a4 g16([ a) g8] f2
  %d4 d g f e f f2 f4 f e e a a b8([ a]) g4 a2
  %b2\rest b2\rest b2\rest b2\rest b2\rest
  
  b4 b b8([ d]) c([ b]) a([ g]) f([ g]) a2 a4 b a g f2
  a4 a8 a a4 f8([ g]) a4 b a2
  b4 b b8([ d]) c([ b]) a([ g]) f([ g]) a2 a4 a8([ b]) a4 g f2
   
}

tenorMusic = \relative c {
  f2 f 
  f4 f8 f f4 f f f f2 f4 f f f f f f8([ c d e]) f4 f f c f2
  
  f\breve \bar"|" f2 \bar"|" f\breve \bar"|" f2
  %d4 d d g f g a b g a h c8([ d] c4) b8([ a]) b4 c2
  %d2\rest d2\rest d2\rest d2\rest d2\rest
  %d4 d b a b c c2 c4 h c h c c b8([ a]) g4 a2
  %d8 d g f g a a4 a8 h c h c16([ d]) c8 b16([ a]) g8 a2
  
  f4 f f f f f f8([ c d e]) f4 f f c f2
 
  f4 f8 f f4 f f f f2 f4 f f f f f f8([ c d e])
  f4 f f c f2
}


bassMusic = \relative c {
  % Amin.
  f2 f 
  f4 f8 f f4 f f f f8([ e d c])
  b4 b b f' f f f8([ c d e]) f4 f f c f,2
  
   f\breve \bar"|" b2 \bar"|" b\breve \bar"|" f2
  %d4 d d d d d d d d d d c2 c4 c f2
  %d'2\rest d2\rest d2\rest d2\rest d2\rest
  %d4 d c d e f f2 f4 f c c c c c8([ d]) g4 a2
  %d8 d g f e f f4 f8 f e e a a b16([ a]) g8 a2
 
  b4 b b f' f f f8([ c d e]) f4 f f c f,2
  
  f'4 f8 f f4 f f f f8([ e d c])
  b4 b b f' f f f8([ c d e]) f4 f f c f,2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff = "staff" <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\addlyrics { \tenorWords }
      \new Voice { \global \voiceTwo \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
  %\layout { #(layout-set-staff-size 15) }
}  

midiOutput = \midi {
    \tempo 4 = 50
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}