\version "2.18.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Ridica-voi ochii mei la ceruri"
  subtitle = " "
  composer =  "după Gh. Dobreanu (1911 – 2001)"
  meter = "Andante"
  tagline=""
}

global = {
  \key e \minor
  \time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
  %\cadenzaOn
}

womenWordsOne = \lyrics {
  \set stanza = "1."
  Ri -- di -- ca -- voi o -- chii mei la ce -- ruri,
  De un -- de va ve -- ni a -- ju -- to -- rul meu:
  A -- ju --  to -- rul meu de la Dum -- ne -- zeu,
  Cel ce a fă -- cut ce -- rul şi pă -- mân -- tul.
}  

womenWordsTwo = \lyrics {
  \set stanza = "2."
  Că -- tre Dom -- nul pa -- şii mei voi du -- ce
  Şi Le -- gea Lui va fi în -- drep -- ta -- rea mea.
  Doam -- ne, Doam -- \skip 4
  ne, Doam -- ne, Doam -- \skip 8 ne,
  gla -- sul meu a -- uzi, când mă rog eu Ţi -- e! 
}	

womenWordsThree = \lyrics {
  \set stanza = "3."
  În -- tru Ti -- ne eu mi-am pus nă -- dej -- dea,
  Să nu mă de -- păr -- tezi de la fa -- ţa Ta!
  A -- li -- lu -- i -- a, a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a, sla -- vă Ţi -- e, Doam -- ne! 
}	

sopMusic = \relative c' {
  \repeat volta 2 { e4 fis g2 g fis4 g h4. a8 g2( fis) e2 }
  h'4\rest h c2 h2 e,4 fis g2 fis4 g h4.( a8 g4) fis e2
  \repeat volta 2 {
     g4 d g a8([ c]) h2 g8([ fis]) e4 
     e'4 d8([ c]) h2
    c h a4 h8([ a]) g2 fis4 g h4. a8 g2( fis) e2 }
  %\bar "|."
}

altMusic = \relative c' {
  e4 dis e2 e dis4 e g4. fis8 e2( dis) e
  h'4\rest e,4 fis2 g2 e4 dis e2 dis4 e g4.( fis8 e4) dis h2
  g'4 d e4 fis g2 g8([ fis]) e4 g fis d2
  fis2 g fis8([ e]) e([ dis]) e2
  dis4 e g4. fis8 e2( dis) h  
}

tenorMusic = \relative c {
  e4 h' h2 h2 h4 h d4. c8 h2( a) g
  g2 a g g4 a h2 h4 h d4.( c8 h4) a g2
  g4 d g d' d2 g,8([ fis]) e4 c' h8([ a]) g2 
  a2 h2 c4 h h2 h4 h d4. c8 h2( a) g  
}

bassMusic = \relative c {
  \repeat volta 2 { e4 h e2 e2 h4 e g4. a8 h2( h,) e2 }
  e2 d2 d2 e4 h e2 h4 e g4.( a8 h4) h, e2
  \repeat volta 2 {
    %g4 d b d g2 g4 e fis4 e d8([ c] b4)
    g4 d h d g2 h,4 c c8([ d]) e([ fis]) <g g,>2
    d2 g a4 h e,2 h4 e g4. a8 h2( h,) e2
  }
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \voiceOne \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     \new Voice { \voiceTwo \global \altMusic }   
     %\addlyrics { \womenWordsFour }
    >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      \new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \basWordsOne }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 50
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}