\version "2.18.0"
\language "deutsch"

\paper {
  %system-system-spacing = #'((basic-distance . 16))
  %markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Sfânt"
  subtitle = "glasul 5"
  composer = \markup \center-column { "de Protosinghelul Varlaam" \small 
  "arm. după N. Moldoveanu" }
  meter = "Andante"
  tagline=""
}

global = {
  \key d \minor
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Sfânt, Sfânt, Sfânt e Dom -- nul Sa -- va -- ot,
  plin e ce -- rul şi pă -- mân -- tul de mă -- ri -- rea Ta.
  O -- sa -- na, o -- sa -- na, o -- sa -- na,
  o -- sa -- na __ în -- tru cei de sus.
  Bi -- ne es -- te cu -- vân -- tat cel ce vi -- ne __
  în -- tru nu -- me -- le Dom -- nu -- lui. 
  O -- sa -- na, o -- sa -- na, o -- sa -- na,
  o -- sa -- na __ în -- tru cei de sus.
}
menWords = \lyricmode {
  Sfânt, Sfânt, Sfânt e Dom -- nul Sa -- va -- ot,
  plin e ce -- rul şi pă -- mân -- tul de mă -- ri -- rea Ta.
  O -- sa -- na, o -- sa -- na, o -- sa -- na,

  o -- sa -- na __ în -- tru cei de sus.
  Bi -- ne es -- te cu -- vân -- tat cel ce vi -- ne
  în -- tru nu -- me -- le Dom -- nu -- lui. 
  O -- sa -- na, o -- sa -- na, o -- sa -- na,
  o -- sa -- na în -- tru cei de sus.
}

sopMusic = \relative c' {
  \accidentalStyle forget
  \cadenzaOn

  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h'2^\f^\fermata \bar "|"
  e2^\fermata \bar "|"
  e4^\mf h4 \bar "|"
  c4 h8([ a8)] g4^\< a4 \bar "|"
  h2\!

  % Plin e cerul şi pământul de mărirea Ta
  e4^\f fis4 \bar "|"
  g4.( fis8 e8[ dis8 e8 fis8)] \bar "|"
  e2 \bar "|"
  h4^\p h4 \bar "|"
  c8([ h8 a8 h8)] g2 \bar "|"
  g8([ fis8)] e4 h'4 h4 \bar "|"
  e,2 \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4^\p \bar "|"
  g4 g2 \breathe fis4 \bar "|"
  a4 a2 \breathe g4^\mf \bar "|"
  h4 h2 \bar "|"
  e4^\f fis4 \bar "|"
  g8([ a8] g4) fis4 e4 \bar "|"
  fis4 dis4 \bar "|"
  e2 \bar "|"

  % Bine este cuvântat cel ce vine
  e4^\p h4 \bar "|"
  c4 h8([ a8)] g4 a4 \bar "|"
  h2 a4 d4 \bar "|"
  d8([ c8 h8 c8)] h4~ \tuplet 3/2 { h8([ a8 g8)] } \bar "|"

  % Întru numele Domnului.
  a4 a4 \bar "|"
  e'4( d8[ c8]) h4 a4 \bar "|"
  g8([ a8)] fis8([ g8)] e2 \bar "|" \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4 g4 g2 \bar "|" \breathe 
  fis4 a4 a2 \bar "|" \breathe 
  g4 h4 h2 \bar "|" \bar "|"
  e4 fis4 g8([ a8] g4) \bar "|"
  fis4 e4 fis2 \bar "|" dis2 e^\fermata
  \bar "|."
}

altoMusic = \relative c' {
  \cadenzaOn

  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h'2
  h2
  h4 h4
  c4 h8([ a8)] g4 fis4
  g2

  % Plin e cerul şi pământul de mărirea Ta
  g4 h4
  e4.( dis8 h2)
  h2
  g4 g4
  a8([ g8 fis8 g8)] e2
  g8^\<([ fis8)] e4 fis4 fis4
  e2\! \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4
  g4 g2 \breathe fis4
  fis4 fis2 \breathe g4
  g4 g2
  c4 d4
  e2 dis4 e4
  \accidentalStyle forget
  dis4 h4
  h2

  % Bine este cuvântat cel ce vine
  h4 h4
  c4 h8([ a8)] g4 fis4
  g2 fis4 a4
  a2 g2

  % Întru numele Domnului.
  a4 a4
  c4( h8[ a8]) g4 fis4
  g8([ a8)] fis8([ g8)] e2 \breathe

  % Osana, osana, osana, osana întru cei de sus.
  d4^\mf
  g4 g2 \breathe fis4^\p
  fis4 fis2 \breathe g4^\mf
  g4 g2
  c4 d4 e2
  dis4 e4
  dis2 h2 h2
}

tenorMusic = \relative c' {
  \accidentalStyle forget
  \cadenzaOn

  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h2
  %h h4 h
  g2 g4 g4
  a4 g8([ fis8)] e4 d4
  g2

  % Plin e cerul şi pământul de mărirea Ta
  d2\rest
  h'4. a8 g8([ fis8 g8 a8)]
  g2
  %h2
  e4 e4
  d2 e2
  g8([ fis8)] e4 dis4 dis4
  e2

  % Osana, osana, osana, osana întru cei de sus.
  d4\rest d4
  g4 g4 d4\rest d4
  d4 d4 d4\rest g4
  h4 g4
  c4 c4
  h8([ c8] h4) h4 c4
  \accidentalStyle forget
  h4 h8([ a8)]
  g2

  % Bine este cuvântat cel ce vine
  e8([ fis8)] g4
  a4 g8([ fis8)] e4 d4
  g2 d4 d4
  d2 e2

  % Întru numele Domnului.
  a4 a4
  a2 e4 fis4
  g8([ a8)] fis8([ g8)] e2

  % Osana, osana, osana, osana întru cei de sus.
  d4\rest d4\rest
  g8[ g] g4 
  d4\rest d4\rest
  a'8[ a] a4 
  d,4\rest d4\rest
  g8[ g] g4
  c4 c4 c2 h4 c4
  h2 h4( a4) g2 %h2 
}

bassMusic = \relative c' {
  \accidentalStyle forget
  \cadenzaOn

  % Sfânt, Sfânt, Sfânt e Domnul Savaot,
  h2
  e,2
  e4 e4
  a4 g8([ fis8)] e4 d4
  g2

  % Plin e cerul şi pământul de mărirea Ta
  d2\rest
  e4. fis8 g8([ fis8 e8 dis8)]
  e2
  e4 e4
  d2 e2
  g8([ fis8)] e4 h4 h4
  e2

  % Osana, osana, osana, osana întru cei de sus.
  d4\rest d4
  g4 g4 d4\rest d4
  d4 d4 d4\rest g4
  h4 g4
  c4 a4
  e2 fis4 g4
  \accidentalStyle forget
  h4 h,4
  e2

  % Bine este cuvântat cel ce vine
  e8([ fis8)] g4
  a4 g8([ fis8)] e4 d4
  g2 d4 d4
  d2 e2

  % Întru numele Domnului.
  a4 a4
  a2 e4 fis4
  g8([ a8)] fis8([ g8)] e2

  % Osana, osana, osana, osana întru cei de sus.
  d4\rest d4\rest
  g8[ g] g4 
  d4\rest d4\rest
  d8[ d] d4 
  d4\rest d4\rest
  g8[ g] g4
  c4 c4 c2 h4 c4
  h2 h,2 e2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \transpose e d \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \transpose e d \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \transpose e d \tenorMusic }
      \new Voice { \voiceTwo \global \transpose e d \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \altoMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \transpose e d \bassMusic }
  \midi { \midiOutput }
}
